﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LECore.Structures;

namespace LayoutEditor.src.Forms.ToolWindows.StateSettingWindow
{
    public partial class EditStateEventPanel : UserControl
    {
        public EditStateEventPanel()
        {
            InitializeComponent();

            foreach(var kind in Enum.GetValues(typeof(StateMachineEventKind)))
            {
                _cmbStateMachineEventKind.Items.Add(kind.ToString());
            }
        }

        ISubScene _subScene;

        public void Setup(ISubScene subScene, StateMachineEventKind kind, uint delay, object param1, object param2)
        {
            _subScene = subScene;

            foreach (var item in _cmbStateMachineEventKind.Items)
            {
                if(item.ToString() == kind.ToString())
                {
                    _cmbStateMachineEventKind.SelectedItem = item;
                    break;
                }
            }

            _nudDelay.Value = delay;
            SetupNameSelectPanel_(kind, param1.ToString(), param2.ToString());
        }

        //----------------------------------------------------------

        public StateMachineEventKind StateMachineEventKind
        {
            get
            {
                StateMachineEventKind type = StateMachineEventKind.Hit;

                if (_cmbStateMachineEventKind.SelectedItem != null)
                {
                    Enum.TryParse<StateMachineEventKind>(_cmbStateMachineEventKind.SelectedItem.ToString(), out type);
                }
                return type;
            }
        }

        public object Param1 { get { return _oneNameCohicePanel.String1; } }
        public object Param2 { get { return _oneNameCohicePanel.String2; } }
        public uint Delay { get { return (uint)_nudDelay.Value; } }

        private void SetupNameSelectPanel_(StateMachineEventKind kind, string name1, string name2)
        {
            switch (kind)
            {
                case StateMachineEventKind.StateChangeRequested:

                    var subState = _subScene.GetPaneSet((p) => p.IsStateMachinePartsPane());

                    IEnumerable<IStateLayer> firstLayers = subState.Select(p => p.GetPartsPaneStateMachine().Layers.First());
                    List<IEnumerable<string>> stateNames = new List<IEnumerable<string>>();
                    foreach (var firstLayer in firstLayers)
                    {
                        stateNames.Add(firstLayer.States.Select(s => s.Name));
                    }

                    _oneNameCohicePanel.Setup(
                        "子ペイン名", subState.Select(p => p.PaneName).ToArray(), name1,
                        "遷移するステート", stateNames.ToArray(), name2);
                    _oneNameCohicePanel.Enabled = true;
                    break;
                case StateMachineEventKind.VariableChanged:
                    _oneNameCohicePanel.Setup("変数名", null, string.Empty, "----", null, string.Empty);
                    _oneNameCohicePanel.Enabled = true;
                    break;
                default:
                    _oneNameCohicePanel.Setup("----", null, string.Empty, "----", null, string.Empty);
                    _oneNameCohicePanel.Enabled = false;
                    break;
            }
        }

        private void _cmbStateMachineEventKind_SelectedIndexChanged(object sender, EventArgs e)
        {
            SetupNameSelectPanel_(StateMachineEventKind, this.Param1.ToString(), this.Param2.ToString());
        }
    }
}
