﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LayoutEditor.src.Forms.ToolWindows.StateSettingWindow
{
    public partial class ChoiceFrom2Dlg : Form
    {
        public ChoiceFrom2Dlg()
        {
            InitializeComponent();
        }

        Action<bool> _onButtonClicked;

        public void Setup(string leftText, string rightLabel, Action<bool> onButtonClicked)
        {
            _btnLeft.Text = leftText;
            _btnRight.Text = rightLabel;
            _onButtonClicked = onButtonClicked;
        }

        private void _btnLeft_Click(object sender, EventArgs e)
        {
            Debug.Assert(_onButtonClicked != null);
            _onButtonClicked(true);

            Hide();
        }

        private void _btnRight_Click(object sender, EventArgs e)
        {
            Debug.Assert(_onButtonClicked != null);
            _onButtonClicked(false);

            Hide();
        }

        private void ChoiceFrom2Dlg_Deactivate(object sender, EventArgs e)
        {
            Hide();
        }
    }
}
