﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using LayoutEditor.Forms.ToolWindows.PropertyEditWindow;
using LECore;
using LECore.Structures;
using LECore.Manipulator;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    public partial class TextBoxPropertyPage : TextBoxPanePage
    {
        private PropertyPageInitializeParamaters _initializeParamaters { get; set; }

        //----------------------------------------------------------
        //
        //----------------------------------------------------------

        public TextBoxPropertyPage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreatePartsPageInstance(object arg)
        {
            Ensure.Argument.True(arg is PropertyPageInitializeParamaters);
            var newInstance = new TextBoxPropertyPage();

            var param = arg as PropertyPageInitializeParamaters;
            newInstance._initializeParamaters = param;
            newInstance._TargetIndex = param.TargetIndex;

            return newInstance;
        }

        /// <summary>
        /// UI初期化
        /// </summary>
        protected override void InitializeProperty()
        {
            base.InitializeProperty();

            //--------------------------------------------
            // 上書きプロパティ固有のボタン類を挿入します。
            {
                int currentCtrlCount = BasePanel.Controls.Count;

                BasePanel.Controls.Add(this._lblPartialOption);
                BasePanel.Controls.Add(this._pnlReset);

                // 追加されたコントロールのサイズを足す
                {
                    for (int i = currentCtrlCount; i < BasePanel.Controls.Count; i++)
                    {
                        int addedSizePerCtrl = this.BasePanel.Controls[i].Height + this.BasePanel.Controls[i].Margin.Vertical;
                        this.BasePanel.Height += addedSizePerCtrl;
                    }

                    // 基底クラスでサイズを覚えて UI 調整を行っているので更新します。
                    _FormDefaultHeight = this.BasePanel.Height;
                }

                // 順番を調整します。
                BasePanel.Controls.SetChildIndex(this._lblPartialOption, 0);
                BasePanel.Controls.SetChildIndex(this._pnlReset, BasePanel.Controls.GetChildIndex(ContentGroup) + 1);
            }

            // 種々のUI要素の調整
            {
                bool patialOverwrite = (_initializeParamaters.Option & PartsPropertyUsageOptions.UsePaneExParamaterUseTextBoxText) != 0;
                this.FontInfoGroup.Enabled = !patialOverwrite;
                this.FontSizeGroup.Enabled = !patialOverwrite;
                this.ShadowGroup.Enabled = !patialOverwrite;
                this.EtcGroup.Enabled = !patialOverwrite;
                this.ColorGroup.Enabled = !patialOverwrite;
                this.PositionGroup.Enabled = !patialOverwrite;
                this._lblPartialOption.Visible = patialOverwrite;

                // サイズ調整ボタンを無効化します。
                this.AdjustPaneSizeButton.Enabled = false;
            }
        }

        /// <summary>
        /// 読み込み専用でも編集を許可するかどうか？
        /// <remarks>
        /// 例外的に、編集を許可したいページでオーバーライドします。
        /// </remarks>
        /// </summary>
        protected override bool AllowEditReadOnlyTarget()
        {
            return true;
        }

        //----------------------------------------------------------

        /// <summary>
        /// 変更前テキストボックスを取得します。
        /// </summary>
        private ITextBox GetOriginalTextBox_()
        {
            var pane = _initializeParamaters.Paramaters.PartsLayout.GetOriginalPane(
                _TargetTextBoxMpn.ITextBox.OwnerPane.PaneName);

            return pane != null ? pane.ITextBox : null;
        }


        //----------------------------------------------------------
        // イベントハンドラ
        //----------------------------------------------------------

        private void Event_BtnResetContents_Click(object sender, EventArgs e)
        {
            var originalText = GetOriginalTextBox_();
            if (originalText != null)
            {
                _TargetTextBoxMpn.ContentsText = originalText.ContentsText;
            }
        }

        private void Event_BtnResetTextID_Click(object sender, EventArgs e)
        {
            var originalText = GetOriginalTextBox_();
            if (originalText != null)
            {
                _TargetTextBoxMpn.TextID = originalText.TextID;
            }
        }
    }
}
