﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using LayoutEditor.Forms.ToolWindows.PropertyEditWindow;
using LECore;
using LECore.Structures;
using LECore.Manipulator;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    public class PropertyPageInitializeParamaters
    {
        public readonly DefaultPartsPanePage.InitializeParamaters Paramaters;
        public readonly int TargetIndex;
        public readonly PartsPropertyUsageOptions Option;

        public PropertyPageInitializeParamaters(
            IPartsLayout partsLayout,
            IPartsLayout parentPartsLayout,
            string targetName,
            PaneKind paneKind,
            int targetIndex,
            PartsPropertyUsageOptions option)
        {
            this.Paramaters = new DefaultPartsPanePage.InitializeParamaters(
                partsLayout, parentPartsLayout, targetName, paneKind);

            this.TargetIndex = targetIndex;
            this.Option = option;
        }
    }
}
