﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using LayoutEditor.Forms.ToolWindows.PropertyEditWindow;
using LECore;
using LECore.Manipulator;
using LECore.Structures;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    public partial class PicturePropertyPage : PicturePanePage
    {
        private PropertyPageInitializeParamaters _initializeParamaters { get; set; }

        //----------------------------------------------------------
        //
        //----------------------------------------------------------

        public PicturePropertyPage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static PropertyPage CreatePartsPageInstance(object arg)
        {
            Ensure.Argument.True(arg is PropertyPageInitializeParamaters);
            var newInstance = new PicturePropertyPage();

            var param = arg as PropertyPageInitializeParamaters;
            newInstance._initializeParamaters = param;
            newInstance._TargetIndex = param.TargetIndex;

            return newInstance;
        }

        /// <summary>
        /// 読み込み専用でも編集を許可するかどうか？
        /// <remarks>
        /// 例外的に、編集を許可したいページでオーバーライドします。
        /// </remarks>
        /// </summary>
        protected override bool AllowEditReadOnlyTarget()
        {
            return true;
        }
    }
}
