﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Pane
{
    using Adapters;
    /// <summary>
    /// ConfirmTevAutoCalcDlg の概要の説明です。
    /// </summary>
    public class ConfirmTevAutoCalcDlg : System.Windows.Forms.Form
    {
        private System.Windows.Forms.Label _lblMsg;
        private System.Windows.Forms.Label _lblWaring;
        private System.Windows.Forms.CheckBox _chkNverShowAgain;
        private System.Windows.Forms.Button _btnYes;
        private System.Windows.Forms.Button _btnNo;
        /// <summary>
        /// 必要なデザイナ変数です。
        /// </summary>
        private System.ComponentModel.Container components = null;


        static bool          _NverShowAgain = false;

        /// <summary>
        /// メッセージを以降は表示しないか？
        /// </summary>
        static public bool NeverShowAgain
        {
            get{ return _NverShowAgain;}
        }

        public ConfirmTevAutoCalcDlg()
        {
            //
            // Windows フォーム デザイナ サポートに必要です。
            //
            InitializeComponent();

            _chkNverShowAgain.Checked = _NverShowAgain;
        }

        /// <summary>
        /// 使用されているリソースに後処理を実行します。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if( disposing )
            {
                if(components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose( disposing );
        }

        #region Windows フォーム デザイナで生成されたコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( ConfirmTevAutoCalcDlg ) );
            this._lblMsg = new System.Windows.Forms.Label();
            this._lblWaring = new System.Windows.Forms.Label();
            this._chkNverShowAgain = new System.Windows.Forms.CheckBox();
            this._btnYes = new System.Windows.Forms.Button();
            this._btnNo = new System.Windows.Forms.Button();
            this.SuspendLayout();
            //
            // _lblMsg
            //
            resources.ApplyResources( this._lblMsg, "_lblMsg" );
            this._lblMsg.Name = "_lblMsg";
            //
            // _lblWaring
            //
            this._lblWaring.BackColor = System.Drawing.SystemColors.Control;
            this._lblWaring.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            resources.ApplyResources( this._lblWaring, "_lblWaring" );
            this._lblWaring.Name = "_lblWaring";
            //
            // _chkNverShowAgain
            //
            resources.ApplyResources( this._chkNverShowAgain, "_chkNverShowAgain" );
            this._chkNverShowAgain.Name = "_chkNverShowAgain";
            this._chkNverShowAgain.CheckedChanged += new System.EventHandler( this.Event_ChkNverShowAgain_CheckedChanged );
            //
            // _btnYes
            //
            resources.ApplyResources( this._btnYes, "_btnYes" );
            this._btnYes.Name = "_btnYes";
            this._btnYes.Click += new System.EventHandler( this.Event_BtnYes_Click );
            //
            // _btnNo
            //
            resources.ApplyResources( this._btnNo, "_btnNo" );
            this._btnNo.Name = "_btnNo";
            this._btnNo.Click += new System.EventHandler( this.Event_BtnNo_Click );
            //
            // ConfirmTevAutoCalcDlg
            //
            resources.ApplyResources( this, "$this" );
            this.Controls.Add( this._btnYes );
            this.Controls.Add( this._chkNverShowAgain );
            this.Controls.Add( this._lblWaring );
            this.Controls.Add( this._lblMsg );
            this.Controls.Add( this._btnNo );
            this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
            this.MaximizeBox = false;
            this.MinimizeBox = false;
            this.Name = "ConfirmTevAutoCalcDlg";
            this.ShowInTaskbar = false;
            this.ResumeLayout( false );

        }
        #endregion

        private void Event_BtnYes_Click(object sender, System.EventArgs e)
        {
            this.DialogResult = DialogResult.Yes;
        }

        private void Event_BtnNo_Click(object sender, System.EventArgs e)
        {
            this.DialogResult = DialogResult.No;
        }

        private void Event_ChkNverShowAgain_CheckedChanged(object sender, System.EventArgs e)
        {
            _NverShowAgain = _chkNverShowAgain.Checked;
        }
    }
}
