﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Windows.Forms;
using System.Drawing;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    /// <summary>
    /// OwnerDrawUtil の概要の説明です。
    /// </summary>
    public class OwnerDrawUtil
    {
        /// <summary>
        /// 説明文付き項目描画
        /// </summary>
        public static readonly DrawItemEventHandler UIComboItemDrawHandler = new DrawItemEventHandler(Event_StageArgs_DrawItem);

        public OwnerDrawUtil()
        {
            //
            // TODO: コンストラクタ ロジックをここに追加してください。
            //
        }

        // 引数項目
        private static void Event_StageArgs_DrawItem(object sender, DrawItemEventArgs e)
        {
            e.DrawBackground();

            if (e.Index >= 0)
            {
                string text  = ((ComboBox)sender).Items[e.Index].ToString();
                string title = null;
                string desc  = null;

                // 分割用制御文字がある場合
                int splitIndex = text.LastIndexOf(';');
                if (splitIndex != -1)
                {
                    // 制御文字の左側（タイトル）と右側（説明）に分割
                    title = text.Substring(0, splitIndex);
                    desc  = ": " + text.Substring(splitIndex + 1, text.Length - (splitIndex + 1));
                }
                else
                {
                    title = text;
                }

                // 状態
                bool comboEdit = (e.State & DrawItemState.ComboBoxEdit) != 0;
                bool selected  = (e.State & DrawItemState.Selected)     != 0;

                // 書式を２種類用意
                StringFormat sf1 = new StringFormat();
                StringFormat sf2 = new StringFormat();
                sf1.Alignment     = StringAlignment.Center;
                sf1.LineAlignment = StringAlignment.Center;
                sf2.Alignment     = StringAlignment.Near;
                sf2.LineAlignment = StringAlignment.Center;
                sf2.FormatFlags  |= StringFormatFlags.NoWrap;

                // ブラシ
                Brush brush;
                if (selected) { brush = SystemBrushes.HighlightText; }
                else          { brush = SystemBrushes.WindowText;    }

                // 描画
                using (sf1)
                using (sf2)
                {
                    // コンボボックス項目
                    if (comboEdit)
                    {
                        e.Graphics.DrawString(title, e.Font, brush, e.Bounds, sf1);
                    }
                        // ドロップダウン項目
                    else
                    {
                        // 解説あり
                        if (desc != null)
                        {
                            // タイトル
                            Rectangle rcTitle = e.Bounds;
                            rcTitle.Width = ((ComboBox)sender).Width;
                            e.Graphics.DrawString(title, e.Font, brush, rcTitle, sf1);

                            // 解説
                            Rectangle rcDesc = e.Bounds;
                            rcDesc.X     += rcTitle.Width;
                            rcDesc.Width -= rcTitle.Width;
                            e.Graphics.DrawString(desc, e.Font, brush, rcDesc, sf2);
                        }
                            // 解説なし
                        else
                        {
                            e.Graphics.DrawString(title, e.Font, brush, e.Bounds, sf1);
                        }
                    }
                }
            }

            e.DrawFocusRectangle();
        }
    }
}
