﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using LayoutEditor.Controls;
using LayoutEditor.Utility;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls
{
    using LECore.Structures;

    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;

    /// <summary>
    /// テクスチャ選択ダイアログクラス。
    /// </summary>
    public sealed class TextureSelectDialog : Form
    {
        #region デザイナ変数

        private System.Windows.Forms.Button btnOK;
        private System.Windows.Forms.Button btnCancel;
        private System.Windows.Forms.Panel pnlClient;
        private System.Windows.Forms.Label labBottomBorder;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(TextureSelectDialog));
            this.btnOK = new System.Windows.Forms.Button();
            this.btnCancel = new System.Windows.Forms.Button();
            this.pnlClient = new System.Windows.Forms.Panel();
            this.labBottomBorder = new System.Windows.Forms.Label();
            this.SuspendLayout();
            //
            // btnOK
            //
            this.btnOK.AccessibleDescription = resources.GetString("btnOK.AccessibleDescription");
            this.btnOK.AccessibleName = resources.GetString("btnOK.AccessibleName");
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnOK.Anchor")));
            this.btnOK.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnOK.BackgroundImage")));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnOK.Dock")));
            this.btnOK.Enabled = ((bool)(resources.GetObject("btnOK.Enabled")));
            this.btnOK.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnOK.FlatStyle")));
            this.btnOK.Font = ((System.Drawing.Font)(resources.GetObject("btnOK.Font")));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnOK.ImageAlign")));
            this.btnOK.ImageIndex = ((int)(resources.GetObject("btnOK.ImageIndex")));
            this.btnOK.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnOK.ImeMode")));
            this.btnOK.Location = ((System.Drawing.Point)(resources.GetObject("btnOK.Location")));
            this.btnOK.Name = "btnOK";
            this.btnOK.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnOK.RightToLeft")));
            this.btnOK.Size = ((System.Drawing.Size)(resources.GetObject("btnOK.Size")));
            this.btnOK.TabIndex = ((int)(resources.GetObject("btnOK.TabIndex")));
            this.btnOK.Text = resources.GetString("btnOK.Text");
            this.btnOK.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnOK.TextAlign")));
            this.btnOK.Visible = ((bool)(resources.GetObject("btnOK.Visible")));
            //
            // btnCancel
            //
            this.btnCancel.AccessibleDescription = resources.GetString("btnCancel.AccessibleDescription");
            this.btnCancel.AccessibleName = resources.GetString("btnCancel.AccessibleName");
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("btnCancel.Anchor")));
            this.btnCancel.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("btnCancel.BackgroundImage")));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("btnCancel.Dock")));
            this.btnCancel.Enabled = ((bool)(resources.GetObject("btnCancel.Enabled")));
            this.btnCancel.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("btnCancel.FlatStyle")));
            this.btnCancel.Font = ((System.Drawing.Font)(resources.GetObject("btnCancel.Font")));
            this.btnCancel.Image = ((System.Drawing.Image)(resources.GetObject("btnCancel.Image")));
            this.btnCancel.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnCancel.ImageAlign")));
            this.btnCancel.ImageIndex = ((int)(resources.GetObject("btnCancel.ImageIndex")));
            this.btnCancel.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("btnCancel.ImeMode")));
            this.btnCancel.Location = ((System.Drawing.Point)(resources.GetObject("btnCancel.Location")));
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("btnCancel.RightToLeft")));
            this.btnCancel.Size = ((System.Drawing.Size)(resources.GetObject("btnCancel.Size")));
            this.btnCancel.TabIndex = ((int)(resources.GetObject("btnCancel.TabIndex")));
            this.btnCancel.Text = resources.GetString("btnCancel.Text");
            this.btnCancel.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("btnCancel.TextAlign")));
            this.btnCancel.Visible = ((bool)(resources.GetObject("btnCancel.Visible")));
            //
            // pnlClient
            //
            this.pnlClient.AccessibleDescription = resources.GetString("pnlClient.AccessibleDescription");
            this.pnlClient.AccessibleName = resources.GetString("pnlClient.AccessibleName");
            this.pnlClient.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("pnlClient.Anchor")));
            this.pnlClient.AutoScroll = ((bool)(resources.GetObject("pnlClient.AutoScroll")));
            this.pnlClient.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("pnlClient.AutoScrollMargin")));
            this.pnlClient.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("pnlClient.AutoScrollMinSize")));
            this.pnlClient.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("pnlClient.BackgroundImage")));
            this.pnlClient.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("pnlClient.Dock")));
            this.pnlClient.Enabled = ((bool)(resources.GetObject("pnlClient.Enabled")));
            this.pnlClient.Font = ((System.Drawing.Font)(resources.GetObject("pnlClient.Font")));
            this.pnlClient.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("pnlClient.ImeMode")));
            this.pnlClient.Location = ((System.Drawing.Point)(resources.GetObject("pnlClient.Location")));
            this.pnlClient.Name = "pnlClient";
            this.pnlClient.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("pnlClient.RightToLeft")));
            this.pnlClient.Size = ((System.Drawing.Size)(resources.GetObject("pnlClient.Size")));
            this.pnlClient.TabIndex = ((int)(resources.GetObject("pnlClient.TabIndex")));
            this.pnlClient.Text = resources.GetString("pnlClient.Text");
            this.pnlClient.Visible = ((bool)(resources.GetObject("pnlClient.Visible")));
            //
            // labBottomBorder
            //
            this.labBottomBorder.AccessibleDescription = resources.GetString("labBottomBorder.AccessibleDescription");
            this.labBottomBorder.AccessibleName = resources.GetString("labBottomBorder.AccessibleName");
            this.labBottomBorder.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("labBottomBorder.Anchor")));
            this.labBottomBorder.AutoSize = ((bool)(resources.GetObject("labBottomBorder.AutoSize")));
            this.labBottomBorder.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D;
            this.labBottomBorder.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("labBottomBorder.Dock")));
            this.labBottomBorder.Enabled = ((bool)(resources.GetObject("labBottomBorder.Enabled")));
            this.labBottomBorder.Font = ((System.Drawing.Font)(resources.GetObject("labBottomBorder.Font")));
            this.labBottomBorder.Image = ((System.Drawing.Image)(resources.GetObject("labBottomBorder.Image")));
            this.labBottomBorder.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labBottomBorder.ImageAlign")));
            this.labBottomBorder.ImageIndex = ((int)(resources.GetObject("labBottomBorder.ImageIndex")));
            this.labBottomBorder.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("labBottomBorder.ImeMode")));
            this.labBottomBorder.Location = ((System.Drawing.Point)(resources.GetObject("labBottomBorder.Location")));
            this.labBottomBorder.Name = "labBottomBorder";
            this.labBottomBorder.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("labBottomBorder.RightToLeft")));
            this.labBottomBorder.Size = ((System.Drawing.Size)(resources.GetObject("labBottomBorder.Size")));
            this.labBottomBorder.TabIndex = ((int)(resources.GetObject("labBottomBorder.TabIndex")));
            this.labBottomBorder.Text = resources.GetString("labBottomBorder.Text");
            this.labBottomBorder.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labBottomBorder.TextAlign")));
            this.labBottomBorder.Visible = ((bool)(resources.GetObject("labBottomBorder.Visible")));
            //
            // TextureSelectDialog
            //
            this.AcceptButton = this.btnOK;
            this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
            this.AccessibleName = resources.GetString("$this.AccessibleName");
            this.AutoScaleBaseSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScaleBaseSize")));
            this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
            this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
            this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
            this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
            this.CancelButton = this.btnCancel;
            this.ClientSize = ((System.Drawing.Size)(resources.GetObject("$this.ClientSize")));
            this.Controls.Add(this.labBottomBorder);
            this.Controls.Add(this.pnlClient);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
            this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
            this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
            this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
            this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
            this.MaximizeBox = false;
            this.MaximumSize = ((System.Drawing.Size)(resources.GetObject("$this.MaximumSize")));
            this.MinimizeBox = false;
            this.MinimumSize = ((System.Drawing.Size)(resources.GetObject("$this.MinimumSize")));
            this.Name = "TextureSelectDialog";
            this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
            this.ShowInTaskbar = false;
            this.StartPosition = ((System.Windows.Forms.FormStartPosition)(resources.GetObject("$this.StartPosition")));
            this.Text = resources.GetString("$this.Text");
            this.ResumeLayout(false);

        }
        #endregion

        // テクスチャ選択パネル
        private readonly TextureSelectPanel _panel;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TextureSelectDialog(TexImage iniTexImage, IPane dynamicCapturePane)
        {
            InitializeComponent();

            // アイコン
            // this.Icon = TheApp.LayoutWindow.Icon;

            // 選択パネル作成
            _panel = new TextureSelectPanel();
            _panel.Parent = pnlClient;
            _panel.Dock = DockStyle.Fill;

            if (dynamicCapturePane != null)
            {
                _panel.AddTextureItem(new Texture(TextureMgrHelper.CreateTemporaryCaptureTexture(PaneHelper.CreateCaptureDummyPane(), (int)Math.Round(dynamicCapturePane.Size.X), (int)Math.Round(dynamicCapturePane.Size.Y))));
            }

            // テクスチャ登録
            foreach (Texture texture in TextureManager.TexturesOwnedByCurrentSubScene)
            {
                _panel.AddTextureItem(texture);
            }
#if false
            // パレット登録
            foreach (Palette palette in PaletteManager.Palettes)
            {
                _panel.AddPaletteItem(palette);
            }
#endif

            // 初期選択
            _panel.SelectedTexture = iniTexImage.Texture;
#if false
            _panel.SelectedPalette = iniTexImage.Palette;
#endif
        }

        /// <summary>
        /// テクスチャ。
        /// </summary>
        public Texture Texture
        {
            get { return _panel.SelectedTexture; }
        }

#if false
        /// <summary>
        /// パレット。
        /// </summary>
        public Palette Palette
        {
            get { return _panel.SelectedPalette; }
        }
#endif

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
    }
}
