﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

using LayoutEditor.Controls;
using LayoutEditor.Utility;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.TextureControls
{
    using LECore.Structures;

    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    /// <summary>
    /// テクスチャ追加ダイアログデータ選択ページクラス。
    /// </summary>
    public sealed class TextureAddDataPage : UserControl
    {
        #region デザイナ変数

        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            //
            // TextureAddDataPage
            //
            this.Font = new System.Drawing.Font("Tahoma", 8.25F);
            this.Name = "TextureAddDataPage";
            this.Size = new System.Drawing.Size(288, 184);

        }
        #endregion

        // テクスチャ選択パネル
        private readonly TextureSelectPanel _panel;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TextureAddDataPage(IPane dynamicCapturePane)
        {
            InitializeComponent();

            // 選択パネル作成
            _panel = new TextureSelectPanel();
            _panel.Parent = this;
            _panel.Dock = DockStyle.Fill;

            if (dynamicCapturePane != null)
            {
                _panel.AddTextureItem(new Texture(TextureMgrHelper.CreateTemporaryCaptureTexture(PaneHelper.CreateCaptureDummyPane(), (int)Math.Round(dynamicCapturePane.Size.X), (int)Math.Round(dynamicCapturePane.Size.Y))));
            }

            // テクスチャ登録
            foreach (Texture texture in TextureManager.TexturesOwnedByCurrentSubScene)
            {
                _panel.AddTextureItem(texture);
            }
#if false
            // パレット登録
            foreach (Palette palette in PaletteManager.Palettes)
            {
                _panel.AddPaletteItem(palette);
            }
#endif
        }

        /// <summary>
        /// テクスチャ。
        /// </summary>
        public Texture Texture
        {
            get { return _panel.SelectedTexture; }
        }

#if false
        /// <summary>
        /// パレット。
        /// </summary>
        public Palette Palette
        {
            get { return _panel.SelectedPalette; }
        }
#endif

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
    }
}
