﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Windows.Forms;


namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TevControls
{
    using LayoutEditor.Controls;
    using LayoutEditor.Utility;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures;
    using App = LayoutEditor;

    /// <summary>
    /// ＴＥＶコンペアモードステージパネルクラス。
    /// </summary>
    public class TevCompStagePanel : UserControl
    {
        #region デザイナ変数

        private System.Windows.Forms.Label labA;
        private App.Controls.UIComboBox cmbA;
        private System.Windows.Forms.Label labB;
        private App.Controls.UIComboBox cmbB;
        private System.Windows.Forms.Label labC;
        private App.Controls.UIComboBox cmbC;
        private System.Windows.Forms.Label labD;
        private App.Controls.UIComboBox cmbD;
        private System.Windows.Forms.Label labComponent;
        private App.Controls.UIComboBox cmbComponent;
        private System.Windows.Forms.Label labMethod;
        private App.Controls.UIComboBox cmbMethod;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(TevCompStagePanel));
            this.labA = new System.Windows.Forms.Label();
            this.cmbA = new App.Controls.UIComboBox();
            this.labB = new System.Windows.Forms.Label();
            this.cmbB = new App.Controls.UIComboBox();
            this.labC = new System.Windows.Forms.Label();
            this.cmbC = new App.Controls.UIComboBox();
            this.labD = new System.Windows.Forms.Label();
            this.cmbD = new App.Controls.UIComboBox();
            this.labComponent = new System.Windows.Forms.Label();
            this.cmbComponent = new App.Controls.UIComboBox();
            this.labMethod = new System.Windows.Forms.Label();
            this.cmbMethod = new App.Controls.UIComboBox();
            this.SuspendLayout();
            //
            // labA
            //
            this.labA.AccessibleDescription = resources.GetString("labA.AccessibleDescription");
            this.labA.AccessibleName = resources.GetString("labA.AccessibleName");
            this.labA.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("labA.Anchor")));
            this.labA.AutoSize = ((bool)(resources.GetObject("labA.AutoSize")));
            this.labA.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("labA.Dock")));
            this.labA.Enabled = ((bool)(resources.GetObject("labA.Enabled")));
            this.labA.Font = ((System.Drawing.Font)(resources.GetObject("labA.Font")));
            this.labA.ForeColor = System.Drawing.Color.Blue;
            this.labA.Image = ((System.Drawing.Image)(resources.GetObject("labA.Image")));
            this.labA.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labA.ImageAlign")));
            this.labA.ImageIndex = ((int)(resources.GetObject("labA.ImageIndex")));
            this.labA.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("labA.ImeMode")));
            this.labA.Location = ((System.Drawing.Point)(resources.GetObject("labA.Location")));
            this.labA.Name = "labA";
            this.labA.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("labA.RightToLeft")));
            this.labA.Size = ((System.Drawing.Size)(resources.GetObject("labA.Size")));
            this.labA.TabIndex = ((int)(resources.GetObject("labA.TabIndex")));
            this.labA.Text = resources.GetString("labA.Text");
            this.labA.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labA.TextAlign")));
            this.labA.Visible = ((bool)(resources.GetObject("labA.Visible")));
            //
            // cmbA
            //
            this.cmbA.AccessibleDescription = resources.GetString("cmbA.AccessibleDescription");
            this.cmbA.AccessibleName = resources.GetString("cmbA.AccessibleName");
            this.cmbA.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmbA.Anchor")));
            this.cmbA.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmbA.BackgroundImage")));
            this.cmbA.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmbA.Dock")));
            this.cmbA.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this.cmbA.Enabled = ((bool)(resources.GetObject("cmbA.Enabled")));
            this.cmbA.Font = ((System.Drawing.Font)(resources.GetObject("cmbA.Font")));
            this.cmbA.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmbA.ImeMode")));
            this.cmbA.IntegralHeight = ((bool)(resources.GetObject("cmbA.IntegralHeight")));
            this.cmbA.ItemHeight = ((int)(resources.GetObject("cmbA.ItemHeight")));
            this.cmbA.Location = ((System.Drawing.Point)(resources.GetObject("cmbA.Location")));
            this.cmbA.MaxDropDownItems = ((int)(resources.GetObject("cmbA.MaxDropDownItems")));
            this.cmbA.MaxLength = ((int)(resources.GetObject("cmbA.MaxLength")));
            this.cmbA.Name = "cmbA";
            this.cmbA.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmbA.RightToLeft")));
            this.cmbA.SelectedItemData = null;
            this.cmbA.Size = ((System.Drawing.Size)(resources.GetObject("cmbA.Size")));
            this.cmbA.TabIndex = ((int)(resources.GetObject("cmbA.TabIndex")));
            this.cmbA.Text = resources.GetString("cmbA.Text");
            this.cmbA.Visible = ((bool)(resources.GetObject("cmbA.Visible")));
            //
            // labB
            //
            this.labB.AccessibleDescription = resources.GetString("labB.AccessibleDescription");
            this.labB.AccessibleName = resources.GetString("labB.AccessibleName");
            this.labB.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("labB.Anchor")));
            this.labB.AutoSize = ((bool)(resources.GetObject("labB.AutoSize")));
            this.labB.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("labB.Dock")));
            this.labB.Enabled = ((bool)(resources.GetObject("labB.Enabled")));
            this.labB.Font = ((System.Drawing.Font)(resources.GetObject("labB.Font")));
            this.labB.ForeColor = System.Drawing.Color.Blue;
            this.labB.Image = ((System.Drawing.Image)(resources.GetObject("labB.Image")));
            this.labB.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labB.ImageAlign")));
            this.labB.ImageIndex = ((int)(resources.GetObject("labB.ImageIndex")));
            this.labB.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("labB.ImeMode")));
            this.labB.Location = ((System.Drawing.Point)(resources.GetObject("labB.Location")));
            this.labB.Name = "labB";
            this.labB.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("labB.RightToLeft")));
            this.labB.Size = ((System.Drawing.Size)(resources.GetObject("labB.Size")));
            this.labB.TabIndex = ((int)(resources.GetObject("labB.TabIndex")));
            this.labB.Text = resources.GetString("labB.Text");
            this.labB.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labB.TextAlign")));
            this.labB.Visible = ((bool)(resources.GetObject("labB.Visible")));
            //
            // cmbB
            //
            this.cmbB.AccessibleDescription = resources.GetString("cmbB.AccessibleDescription");
            this.cmbB.AccessibleName = resources.GetString("cmbB.AccessibleName");
            this.cmbB.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmbB.Anchor")));
            this.cmbB.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmbB.BackgroundImage")));
            this.cmbB.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmbB.Dock")));
            this.cmbB.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this.cmbB.Enabled = ((bool)(resources.GetObject("cmbB.Enabled")));
            this.cmbB.Font = ((System.Drawing.Font)(resources.GetObject("cmbB.Font")));
            this.cmbB.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmbB.ImeMode")));
            this.cmbB.IntegralHeight = ((bool)(resources.GetObject("cmbB.IntegralHeight")));
            this.cmbB.ItemHeight = ((int)(resources.GetObject("cmbB.ItemHeight")));
            this.cmbB.Location = ((System.Drawing.Point)(resources.GetObject("cmbB.Location")));
            this.cmbB.MaxDropDownItems = ((int)(resources.GetObject("cmbB.MaxDropDownItems")));
            this.cmbB.MaxLength = ((int)(resources.GetObject("cmbB.MaxLength")));
            this.cmbB.Name = "cmbB";
            this.cmbB.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmbB.RightToLeft")));
            this.cmbB.SelectedItemData = null;
            this.cmbB.Size = ((System.Drawing.Size)(resources.GetObject("cmbB.Size")));
            this.cmbB.TabIndex = ((int)(resources.GetObject("cmbB.TabIndex")));
            this.cmbB.Text = resources.GetString("cmbB.Text");
            this.cmbB.Visible = ((bool)(resources.GetObject("cmbB.Visible")));
            //
            // labC
            //
            this.labC.AccessibleDescription = resources.GetString("labC.AccessibleDescription");
            this.labC.AccessibleName = resources.GetString("labC.AccessibleName");
            this.labC.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("labC.Anchor")));
            this.labC.AutoSize = ((bool)(resources.GetObject("labC.AutoSize")));
            this.labC.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("labC.Dock")));
            this.labC.Enabled = ((bool)(resources.GetObject("labC.Enabled")));
            this.labC.Font = ((System.Drawing.Font)(resources.GetObject("labC.Font")));
            this.labC.ForeColor = System.Drawing.Color.Blue;
            this.labC.Image = ((System.Drawing.Image)(resources.GetObject("labC.Image")));
            this.labC.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labC.ImageAlign")));
            this.labC.ImageIndex = ((int)(resources.GetObject("labC.ImageIndex")));
            this.labC.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("labC.ImeMode")));
            this.labC.Location = ((System.Drawing.Point)(resources.GetObject("labC.Location")));
            this.labC.Name = "labC";
            this.labC.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("labC.RightToLeft")));
            this.labC.Size = ((System.Drawing.Size)(resources.GetObject("labC.Size")));
            this.labC.TabIndex = ((int)(resources.GetObject("labC.TabIndex")));
            this.labC.Text = resources.GetString("labC.Text");
            this.labC.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labC.TextAlign")));
            this.labC.Visible = ((bool)(resources.GetObject("labC.Visible")));
            //
            // cmbC
            //
            this.cmbC.AccessibleDescription = resources.GetString("cmbC.AccessibleDescription");
            this.cmbC.AccessibleName = resources.GetString("cmbC.AccessibleName");
            this.cmbC.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmbC.Anchor")));
            this.cmbC.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmbC.BackgroundImage")));
            this.cmbC.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmbC.Dock")));
            this.cmbC.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this.cmbC.Enabled = ((bool)(resources.GetObject("cmbC.Enabled")));
            this.cmbC.Font = ((System.Drawing.Font)(resources.GetObject("cmbC.Font")));
            this.cmbC.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmbC.ImeMode")));
            this.cmbC.IntegralHeight = ((bool)(resources.GetObject("cmbC.IntegralHeight")));
            this.cmbC.ItemHeight = ((int)(resources.GetObject("cmbC.ItemHeight")));
            this.cmbC.Location = ((System.Drawing.Point)(resources.GetObject("cmbC.Location")));
            this.cmbC.MaxDropDownItems = ((int)(resources.GetObject("cmbC.MaxDropDownItems")));
            this.cmbC.MaxLength = ((int)(resources.GetObject("cmbC.MaxLength")));
            this.cmbC.Name = "cmbC";
            this.cmbC.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmbC.RightToLeft")));
            this.cmbC.SelectedItemData = null;
            this.cmbC.Size = ((System.Drawing.Size)(resources.GetObject("cmbC.Size")));
            this.cmbC.TabIndex = ((int)(resources.GetObject("cmbC.TabIndex")));
            this.cmbC.Text = resources.GetString("cmbC.Text");
            this.cmbC.Visible = ((bool)(resources.GetObject("cmbC.Visible")));
            //
            // labD
            //
            this.labD.AccessibleDescription = resources.GetString("labD.AccessibleDescription");
            this.labD.AccessibleName = resources.GetString("labD.AccessibleName");
            this.labD.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("labD.Anchor")));
            this.labD.AutoSize = ((bool)(resources.GetObject("labD.AutoSize")));
            this.labD.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("labD.Dock")));
            this.labD.Enabled = ((bool)(resources.GetObject("labD.Enabled")));
            this.labD.Font = ((System.Drawing.Font)(resources.GetObject("labD.Font")));
            this.labD.ForeColor = System.Drawing.Color.Blue;
            this.labD.Image = ((System.Drawing.Image)(resources.GetObject("labD.Image")));
            this.labD.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labD.ImageAlign")));
            this.labD.ImageIndex = ((int)(resources.GetObject("labD.ImageIndex")));
            this.labD.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("labD.ImeMode")));
            this.labD.Location = ((System.Drawing.Point)(resources.GetObject("labD.Location")));
            this.labD.Name = "labD";
            this.labD.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("labD.RightToLeft")));
            this.labD.Size = ((System.Drawing.Size)(resources.GetObject("labD.Size")));
            this.labD.TabIndex = ((int)(resources.GetObject("labD.TabIndex")));
            this.labD.Text = resources.GetString("labD.Text");
            this.labD.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labD.TextAlign")));
            this.labD.Visible = ((bool)(resources.GetObject("labD.Visible")));
            //
            // cmbD
            //
            this.cmbD.AccessibleDescription = resources.GetString("cmbD.AccessibleDescription");
            this.cmbD.AccessibleName = resources.GetString("cmbD.AccessibleName");
            this.cmbD.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmbD.Anchor")));
            this.cmbD.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmbD.BackgroundImage")));
            this.cmbD.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmbD.Dock")));
            this.cmbD.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            this.cmbD.Enabled = ((bool)(resources.GetObject("cmbD.Enabled")));
            this.cmbD.Font = ((System.Drawing.Font)(resources.GetObject("cmbD.Font")));
            this.cmbD.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmbD.ImeMode")));
            this.cmbD.IntegralHeight = ((bool)(resources.GetObject("cmbD.IntegralHeight")));
            this.cmbD.ItemHeight = ((int)(resources.GetObject("cmbD.ItemHeight")));
            this.cmbD.Location = ((System.Drawing.Point)(resources.GetObject("cmbD.Location")));
            this.cmbD.MaxDropDownItems = ((int)(resources.GetObject("cmbD.MaxDropDownItems")));
            this.cmbD.MaxLength = ((int)(resources.GetObject("cmbD.MaxLength")));
            this.cmbD.Name = "cmbD";
            this.cmbD.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmbD.RightToLeft")));
            this.cmbD.SelectedItemData = null;
            this.cmbD.Size = ((System.Drawing.Size)(resources.GetObject("cmbD.Size")));
            this.cmbD.TabIndex = ((int)(resources.GetObject("cmbD.TabIndex")));
            this.cmbD.Text = resources.GetString("cmbD.Text");
            this.cmbD.Visible = ((bool)(resources.GetObject("cmbD.Visible")));
            //
            // labComponent
            //
            this.labComponent.AccessibleDescription = resources.GetString("labComponent.AccessibleDescription");
            this.labComponent.AccessibleName = resources.GetString("labComponent.AccessibleName");
            this.labComponent.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("labComponent.Anchor")));
            this.labComponent.AutoSize = ((bool)(resources.GetObject("labComponent.AutoSize")));
            this.labComponent.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("labComponent.Dock")));
            this.labComponent.Enabled = ((bool)(resources.GetObject("labComponent.Enabled")));
            this.labComponent.Font = ((System.Drawing.Font)(resources.GetObject("labComponent.Font")));
            this.labComponent.Image = ((System.Drawing.Image)(resources.GetObject("labComponent.Image")));
            this.labComponent.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labComponent.ImageAlign")));
            this.labComponent.ImageIndex = ((int)(resources.GetObject("labComponent.ImageIndex")));
            this.labComponent.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("labComponent.ImeMode")));
            this.labComponent.Location = ((System.Drawing.Point)(resources.GetObject("labComponent.Location")));
            this.labComponent.Name = "labComponent";
            this.labComponent.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("labComponent.RightToLeft")));
            this.labComponent.Size = ((System.Drawing.Size)(resources.GetObject("labComponent.Size")));
            this.labComponent.TabIndex = ((int)(resources.GetObject("labComponent.TabIndex")));
            this.labComponent.Text = resources.GetString("labComponent.Text");
            this.labComponent.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labComponent.TextAlign")));
            this.labComponent.Visible = ((bool)(resources.GetObject("labComponent.Visible")));
            //
            // cmbComponent
            //
            this.cmbComponent.AccessibleDescription = resources.GetString("cmbComponent.AccessibleDescription");
            this.cmbComponent.AccessibleName = resources.GetString("cmbComponent.AccessibleName");
            this.cmbComponent.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmbComponent.Anchor")));
            this.cmbComponent.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmbComponent.BackgroundImage")));
            this.cmbComponent.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmbComponent.Dock")));
            this.cmbComponent.Enabled = ((bool)(resources.GetObject("cmbComponent.Enabled")));
            this.cmbComponent.Font = ((System.Drawing.Font)(resources.GetObject("cmbComponent.Font")));
            this.cmbComponent.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmbComponent.ImeMode")));
            this.cmbComponent.IntegralHeight = ((bool)(resources.GetObject("cmbComponent.IntegralHeight")));
            this.cmbComponent.ItemHeight = ((int)(resources.GetObject("cmbComponent.ItemHeight")));
            this.cmbComponent.Location = ((System.Drawing.Point)(resources.GetObject("cmbComponent.Location")));
            this.cmbComponent.MaxDropDownItems = ((int)(resources.GetObject("cmbComponent.MaxDropDownItems")));
            this.cmbComponent.MaxLength = ((int)(resources.GetObject("cmbComponent.MaxLength")));
            this.cmbComponent.Name = "cmbComponent";
            this.cmbComponent.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmbComponent.RightToLeft")));
            this.cmbComponent.SelectedItemData = null;
            this.cmbComponent.Size = ((System.Drawing.Size)(resources.GetObject("cmbComponent.Size")));
            this.cmbComponent.TabIndex = ((int)(resources.GetObject("cmbComponent.TabIndex")));
            this.cmbComponent.Text = resources.GetString("cmbComponent.Text");
            this.cmbComponent.Visible = ((bool)(resources.GetObject("cmbComponent.Visible")));
            //
            // labMethod
            //
            this.labMethod.AccessibleDescription = resources.GetString("labMethod.AccessibleDescription");
            this.labMethod.AccessibleName = resources.GetString("labMethod.AccessibleName");
            this.labMethod.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("labMethod.Anchor")));
            this.labMethod.AutoSize = ((bool)(resources.GetObject("labMethod.AutoSize")));
            this.labMethod.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("labMethod.Dock")));
            this.labMethod.Enabled = ((bool)(resources.GetObject("labMethod.Enabled")));
            this.labMethod.Font = ((System.Drawing.Font)(resources.GetObject("labMethod.Font")));
            this.labMethod.Image = ((System.Drawing.Image)(resources.GetObject("labMethod.Image")));
            this.labMethod.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labMethod.ImageAlign")));
            this.labMethod.ImageIndex = ((int)(resources.GetObject("labMethod.ImageIndex")));
            this.labMethod.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("labMethod.ImeMode")));
            this.labMethod.Location = ((System.Drawing.Point)(resources.GetObject("labMethod.Location")));
            this.labMethod.Name = "labMethod";
            this.labMethod.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("labMethod.RightToLeft")));
            this.labMethod.Size = ((System.Drawing.Size)(resources.GetObject("labMethod.Size")));
            this.labMethod.TabIndex = ((int)(resources.GetObject("labMethod.TabIndex")));
            this.labMethod.Text = resources.GetString("labMethod.Text");
            this.labMethod.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("labMethod.TextAlign")));
            this.labMethod.Visible = ((bool)(resources.GetObject("labMethod.Visible")));
            //
            // cmbMethod
            //
            this.cmbMethod.AccessibleDescription = resources.GetString("cmbMethod.AccessibleDescription");
            this.cmbMethod.AccessibleName = resources.GetString("cmbMethod.AccessibleName");
            this.cmbMethod.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("cmbMethod.Anchor")));
            this.cmbMethod.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("cmbMethod.BackgroundImage")));
            this.cmbMethod.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("cmbMethod.Dock")));
            this.cmbMethod.Enabled = ((bool)(resources.GetObject("cmbMethod.Enabled")));
            this.cmbMethod.Font = ((System.Drawing.Font)(resources.GetObject("cmbMethod.Font")));
            this.cmbMethod.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("cmbMethod.ImeMode")));
            this.cmbMethod.IntegralHeight = ((bool)(resources.GetObject("cmbMethod.IntegralHeight")));
            this.cmbMethod.ItemHeight = ((int)(resources.GetObject("cmbMethod.ItemHeight")));
            this.cmbMethod.Location = ((System.Drawing.Point)(resources.GetObject("cmbMethod.Location")));
            this.cmbMethod.MaxDropDownItems = ((int)(resources.GetObject("cmbMethod.MaxDropDownItems")));
            this.cmbMethod.MaxLength = ((int)(resources.GetObject("cmbMethod.MaxLength")));
            this.cmbMethod.Name = "cmbMethod";
            this.cmbMethod.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("cmbMethod.RightToLeft")));
            this.cmbMethod.SelectedItemData = null;
            this.cmbMethod.Size = ((System.Drawing.Size)(resources.GetObject("cmbMethod.Size")));
            this.cmbMethod.TabIndex = ((int)(resources.GetObject("cmbMethod.TabIndex")));
            this.cmbMethod.Text = resources.GetString("cmbMethod.Text");
            this.cmbMethod.Visible = ((bool)(resources.GetObject("cmbMethod.Visible")));
            //
            // TevCompStagePanel
            //
            this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
            this.AccessibleName = resources.GetString("$this.AccessibleName");
            this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
            this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
            this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
            this.BackColor = System.Drawing.Color.Honeydew;
            this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
            this.Controls.Add(this.cmbMethod);
            this.Controls.Add(this.labMethod);
            this.Controls.Add(this.cmbComponent);
            this.Controls.Add(this.labComponent);
            this.Controls.Add(this.cmbD);
            this.Controls.Add(this.labD);
            this.Controls.Add(this.cmbC);
            this.Controls.Add(this.labC);
            this.Controls.Add(this.cmbB);
            this.Controls.Add(this.labB);
            this.Controls.Add(this.cmbA);
            this.Controls.Add(this.labA);
            this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
            this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
            this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
            this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
            this.Name = "TevCompStagePanel";
            this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
            this.Size = ((System.Drawing.Size)(resources.GetObject("$this.Size")));
            this.ResumeLayout(false);

        }
        #endregion

        // 参照データ
        private TevDirectStage _refData = null;

        /// <summary>データ変更イベント。</summary>
        public event EventHandler DataChanged = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TevCompStagePanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 参照データ。
        /// </summary>
        public TevDirectStage RefData
        {
            set { _refData = value; }
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        public virtual void InitializeProperty()
        {
            // 引数
            // 項目作成は派生クラスで
            cmbA.SelectedIndexChanged += new EventHandler(Event_CmbA_SelectedIndexChanged);
            cmbB.SelectedIndexChanged += new EventHandler(Event_CmbB_SelectedIndexChanged);
            cmbC.SelectedIndexChanged += new EventHandler(Event_CmbC_SelectedIndexChanged);
            cmbD.SelectedIndexChanged += new EventHandler(Event_CmbD_SelectedIndexChanged);

            // 比較成分
            // 項目作成は派生クラスで
            cmbComponent.SelectedIndexChanged += new EventHandler(Event_CmbOp_SelectedIndexChanged);

            // 比較方法
            cmbMethod.AddItem("PROP_MAT_TEV_STAGE_COMP_OP_EQ", CompMethod.EQ, true);
            cmbMethod.AddItem("PROP_MAT_TEV_STAGE_COMP_OP_GT", CompMethod.GT, true);
            cmbMethod.SelectedIndexChanged += new EventHandler(Event_CmbOp_SelectedIndexChanged);

            // コンボボックス独自描画
            cmbA.DrawItem += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbB.DrawItem += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbC.DrawItem += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbD.DrawItem += OwnerDrawUtil.UIComboItemDrawHandler;

            const int dropDownW = 260;
            cmbA.DropDownWidth = dropDownW;
            cmbB.DropDownWidth = dropDownW;
            cmbC.DropDownWidth = dropDownW;
            cmbD.DropDownWidth = dropDownW;
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        public void UpdateProperty()
        {
            cmbA.SetSelectedItemData(_refData.A);
            cmbB.SetSelectedItemData(_refData.B);
            cmbC.SetSelectedItemData(_refData.C);
            cmbD.SetSelectedItemData(_refData.D);

            switch (_refData.Op)
            {
            // GT比較
            case AttrTevOp.CompR8Gt:
                cmbComponent.SetSelectedItemData(CompComponent.R8);
                cmbMethod.SetSelectedItemData(CompMethod.GT);
                break;
            case AttrTevOp.CompGr16Gt:
                cmbComponent.SetSelectedItemData(CompComponent.GR16);
                cmbMethod.SetSelectedItemData(CompMethod.GT);
                break;
            case AttrTevOp.CompBgr24Gt:
                cmbComponent.SetSelectedItemData(CompComponent.BGR24);
                cmbMethod.SetSelectedItemData(CompMethod.GT);
                break;
            case AttrTevOp.CompRgb8Gt:
                cmbComponent.SetSelectedItemData(CompComponent.RGB8);
                cmbMethod.SetSelectedItemData(CompMethod.GT);
                break;
            case AttrTevOp.CompA8Gt:
                cmbComponent.SetSelectedItemData(CompComponent.A8);
                cmbMethod.SetSelectedItemData(CompMethod.GT);
                break;
            // EQ比較
            case AttrTevOp.CompR8Eq:
                cmbComponent.SetSelectedItemData(CompComponent.R8);
                cmbMethod.SetSelectedItemData(CompMethod.EQ);
                break;
            case AttrTevOp.CompGr16Eq:
                cmbComponent.SetSelectedItemData(CompComponent.GR16);
                cmbMethod.SetSelectedItemData(CompMethod.EQ);
                break;
            case AttrTevOp.CompBgr24Eq:
                cmbComponent.SetSelectedItemData(CompComponent.BGR24);
                cmbMethod.SetSelectedItemData(CompMethod.EQ);
                break;
            case AttrTevOp.CompRgb8Eq:
                cmbComponent.SetSelectedItemData(CompComponent.RGB8);
                cmbMethod.SetSelectedItemData(CompMethod.EQ);
                break;
            case AttrTevOp.CompA8Eq:
                cmbComponent.SetSelectedItemData(CompComponent.A8);
                cmbMethod.SetSelectedItemData(CompMethod.EQ);
                break;
            default:
                Debug.Assert(false);
                break;
            }
        }

        /// <summary>
        /// 引数項目追加。
        /// </summary>
        protected void AddArgItem(string strID, AttrTevArg val)
        {
            cmbA.AddItem(strID, val, true);
            cmbB.AddItem(strID, val, true);
            cmbC.AddItem(strID, val, true);
            cmbD.AddItem(strID, val, true);
        }

        /// <summary>
        /// 比較成分項目追加。
        /// </summary>
        protected void AddComponentItem(string stringID, CompComponent val)
        {
            cmbComponent.AddItem(stringID, val, true);
        }

        /// <summary>
        /// データ変更ハンドラ。
        /// </summary>
        protected virtual void OnDataChanged(EventArgs e)
        {
            if (this.DataChanged != null)
            {
                this.DataChanged(this, e);
            }
        }

        /// <summary>
        /// 演算方法に変換。
        /// </summary>
        private AttrTevOp ToOp(CompComponent component, CompMethod method)
        {
            switch (component)
            {
            case CompComponent.R8:
                if (method == CompMethod.GT) { return AttrTevOp.CompR8Gt; }
                else                         { return AttrTevOp.CompR8Eq; }
            case CompComponent.GR16:
                if (method == CompMethod.GT) { return AttrTevOp.CompGr16Gt; }
                else                         { return AttrTevOp.CompGr16Eq; }
            case CompComponent.BGR24:
                if (method == CompMethod.GT) { return AttrTevOp.CompBgr24Gt; }
                else                         { return AttrTevOp.CompBgr24Eq; }
            case CompComponent.RGB8:
                if (method == CompMethod.GT) { return AttrTevOp.CompRgb8Gt; }
                else                         { return AttrTevOp.CompRgb8Eq; }
            case CompComponent.A8:
                if (method == CompMethod.GT) { return AttrTevOp.CompA8Gt; }
                else                         { return AttrTevOp.CompA8Eq; }
            default:
                Debug.Assert(false);
                return AttrTevOp._Unknown;
            }
        }

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion

        #region イベントハンドラ
        private void Event_CmbA_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.A = (AttrTevArg)cmbA.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbB_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.B = (AttrTevArg)cmbB.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbC_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.C = (AttrTevArg)cmbC.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbD_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.D = (AttrTevArg)cmbD.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbOp_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.Op = ToOp(
                (CompComponent)cmbComponent.SelectedItemData,
                (CompMethod)cmbMethod.SelectedItemData
            );
            OnDataChanged(EventArgs.Empty);
        }
        #endregion

        #region CompComponent
        /// <summary>
        /// 比較成分。
        /// </summary>
        protected enum CompComponent
        {
            /// <summary>下位８ビット</summary>
            R8,
            /// <summary>下位１６ビット</summary>
            GR16,
            /// <summary>下位２４ビット</summary>
            BGR24,
            /// <summary>下位から８ビットずつ</summary>
            RGB8,
            /// <summary>上位８ビット</summary>
            A8,
        }
        #endregion

        #region CompMethod
        /// <summary>
        /// 比較方法。
        /// </summary>
        protected enum CompMethod
        {
            /// <summary>></summary>
            GT,
            /// <summary>==</summary>
            EQ,
        }
        #endregion
    }

    #region TevColorCompStagePanel
    /// <summary>
    /// ＴＥＶカラーコンペアモードステージパネルクラス。
    /// </summary>
    public sealed class TevColorCompStagePanel : TevCompStagePanel
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TevColorCompStagePanel() {}

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override void InitializeProperty()
        {
            base.InitializeProperty();

            // 引数項目
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_RASC",  AttrTevArg.RasC);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_RASA",  AttrTevArg.RasA);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_TEXC",  AttrTevArg.TexC);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_TEXA",  AttrTevArg.TexA);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_C0",    AttrTevArg.C0);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A0",    AttrTevArg.A0);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_C1",    AttrTevArg.C1);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A1",    AttrTevArg.A1);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_C2",    AttrTevArg.C2);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A2",    AttrTevArg.A2);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_CPREV", AttrTevArg.CPrev);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_APREV", AttrTevArg.APrev);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_KONST", AttrTevArg.Konst);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_ONE",   AttrTevArg.One);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_HALF",  AttrTevArg.Half);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_ZERO",  AttrTevArg.Zero);

            // 比較成分項目
            AddComponentItem("PROP_MAT_TEV_STAGE_COMP_OP_R8",    CompComponent.R8);
            AddComponentItem("PROP_MAT_TEV_STAGE_COMP_OP_GR16",  CompComponent.GR16);
            AddComponentItem("PROP_MAT_TEV_STAGE_COMP_OP_BGR24", CompComponent.BGR24);
            AddComponentItem("PROP_MAT_TEV_STAGE_COMP_OP_RGB8",  CompComponent.RGB8);
        }
    }
    #endregion

    #region TevAlphaCompStagePanel
    /// <summary>
    /// ＴＥＶアルファコンペアモードステージパネルクラス。
    /// </summary>
    public sealed class TevAlphaCompStagePanel : TevCompStagePanel
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TevAlphaCompStagePanel() {}

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override void InitializeProperty()
        {
            base.InitializeProperty();

            // 引数項目
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_RASA",  AttrTevArg.RasA);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_TEXA",  AttrTevArg.TexA);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A0",    AttrTevArg.A0);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A1",    AttrTevArg.A1);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A2",    AttrTevArg.A2);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_APREV", AttrTevArg.APrev);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_KONST", AttrTevArg.Konst);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_ZERO",  AttrTevArg.Zero);

            // 比較成分項目
            AddComponentItem("PROP_MAT_TEV_STAGE_COMP_OP_R8",    CompComponent.R8);
            AddComponentItem("PROP_MAT_TEV_STAGE_COMP_OP_GR16",  CompComponent.GR16);
            AddComponentItem("PROP_MAT_TEV_STAGE_COMP_OP_BGR24", CompComponent.BGR24);
            AddComponentItem("PROP_MAT_TEV_STAGE_COMP_OP_A8",    CompComponent.A8);
        }
    }
    #endregion
}
