﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;


namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TevControls
{
    using LayoutEditor.Controls;
    using LayoutEditor.Utility;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures;
    using App = LayoutEditor;

    /// <summary>
    /// ＴＥＶ計算式ステージパネルクラス。
    /// </summary>
    public class MaterialPropertyTevDirectStageCalcPanel : UserControl
    {
        #region デザイナ変数

        private App.Controls.UIComboBox cmbD;
        private App.Controls.UIComboBox cmbOp;
        private App.Controls.UIComboBox cmbA;
        private App.Controls.UIComboBox cmbC;
        private App.Controls.UIComboBox cmbB;
        private App.Controls.UIComboBox cmbBias;
        private App.Controls.UIComboBox cmbScale;
        private System.Windows.Forms.Label labD;
        private System.Windows.Forms.Label labC1;
        private System.Windows.Forms.Label labA;
        private System.Windows.Forms.Label labC2;
        private System.Windows.Forms.Label labB;
        private System.Windows.Forms.Label labC;
        private System.Windows.Forms.Label labText1;
        private System.Windows.Forms.Label labText0;
        private System.Windows.Forms.Label labText2;
        private System.Windows.Forms.Label labText3;
        private System.Windows.Forms.Label labText4;
        private System.Windows.Forms.Label labText5;
        private System.Windows.Forms.Label labText6;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( MaterialPropertyTevDirectStageCalcPanel ) );
            this.cmbD = new LayoutEditor.Controls.UIComboBox();
            this.cmbOp = new LayoutEditor.Controls.UIComboBox();
            this.cmbA = new LayoutEditor.Controls.UIComboBox();
            this.cmbC = new LayoutEditor.Controls.UIComboBox();
            this.cmbB = new LayoutEditor.Controls.UIComboBox();
            this.cmbBias = new LayoutEditor.Controls.UIComboBox();
            this.cmbScale = new LayoutEditor.Controls.UIComboBox();
            this.labD = new System.Windows.Forms.Label();
            this.labText1 = new System.Windows.Forms.Label();
            this.labText0 = new System.Windows.Forms.Label();
            this.labText2 = new System.Windows.Forms.Label();
            this.labC1 = new System.Windows.Forms.Label();
            this.labA = new System.Windows.Forms.Label();
            this.labText3 = new System.Windows.Forms.Label();
            this.labC2 = new System.Windows.Forms.Label();
            this.labText4 = new System.Windows.Forms.Label();
            this.labB = new System.Windows.Forms.Label();
            this.labText5 = new System.Windows.Forms.Label();
            this.labText6 = new System.Windows.Forms.Label();
            this.labC = new System.Windows.Forms.Label();
            this.SuspendLayout();
            //
            // cmbD
            //
            this.cmbD.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbD, "cmbD" );
            this.cmbD.Name = "cmbD";
            this.cmbD.SelectedItemData = null;
            //
            // cmbOp
            //
            this.cmbOp.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbOp, "cmbOp" );
            this.cmbOp.Name = "cmbOp";
            this.cmbOp.SelectedItemData = null;
            //
            // cmbA
            //
            this.cmbA.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbA, "cmbA" );
            this.cmbA.Name = "cmbA";
            this.cmbA.SelectedItemData = null;
            //
            // cmbC
            //
            this.cmbC.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbC, "cmbC" );
            this.cmbC.Name = "cmbC";
            this.cmbC.SelectedItemData = null;
            //
            // cmbB
            //
            this.cmbB.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbB, "cmbB" );
            this.cmbB.Name = "cmbB";
            this.cmbB.SelectedItemData = null;
            //
            // cmbBias
            //
            this.cmbBias.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbBias, "cmbBias" );
            this.cmbBias.Name = "cmbBias";
            this.cmbBias.SelectedItemData = null;
            //
            // cmbScale
            //
            this.cmbScale.DrawMode = System.Windows.Forms.DrawMode.OwnerDrawFixed;
            resources.ApplyResources( this.cmbScale, "cmbScale" );
            this.cmbScale.Name = "cmbScale";
            this.cmbScale.SelectedItemData = null;
            //
            // labD
            //
            this.labD.ForeColor = System.Drawing.Color.Blue;
            resources.ApplyResources( this.labD, "labD" );
            this.labD.Name = "labD";
            //
            // labText1
            //
            resources.ApplyResources( this.labText1, "labText1" );
            this.labText1.Name = "labText1";
            //
            // labText0
            //
            resources.ApplyResources( this.labText0, "labText0" );
            this.labText0.Name = "labText0";
            //
            // labText2
            //
            resources.ApplyResources( this.labText2, "labText2" );
            this.labText2.Name = "labText2";
            //
            // labC1
            //
            this.labC1.ForeColor = System.Drawing.Color.Blue;
            resources.ApplyResources( this.labC1, "labC1" );
            this.labC1.Name = "labC1";
            //
            // labA
            //
            this.labA.ForeColor = System.Drawing.Color.Blue;
            resources.ApplyResources( this.labA, "labA" );
            this.labA.Name = "labA";
            //
            // labText3
            //
            resources.ApplyResources( this.labText3, "labText3" );
            this.labText3.Name = "labText3";
            //
            // labC2
            //
            this.labC2.ForeColor = System.Drawing.Color.Blue;
            resources.ApplyResources( this.labC2, "labC2" );
            this.labC2.Name = "labC2";
            //
            // labText4
            //
            resources.ApplyResources( this.labText4, "labText4" );
            this.labText4.Name = "labText4";
            //
            // labB
            //
            this.labB.ForeColor = System.Drawing.Color.Blue;
            resources.ApplyResources( this.labB, "labB" );
            this.labB.Name = "labB";
            //
            // labText5
            //
            resources.ApplyResources( this.labText5, "labText5" );
            this.labText5.Name = "labText5";
            //
            // labText6
            //
            resources.ApplyResources( this.labText6, "labText6" );
            this.labText6.Name = "labText6";
            //
            // labC
            //
            this.labC.BackColor = System.Drawing.SystemColors.Window;
            this.labC.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            resources.ApplyResources( this.labC, "labC" );
            this.labC.Name = "labC";
            //
            // MaterialPropertyTevDirectStageCalcPanel
            //
            this.BackColor = System.Drawing.Color.AntiqueWhite;
            this.Controls.Add( this.labC );
            this.Controls.Add( this.labText6 );
            this.Controls.Add( this.labText5 );
            this.Controls.Add( this.labB );
            this.Controls.Add( this.labText4 );
            this.Controls.Add( this.labC2 );
            this.Controls.Add( this.labText3 );
            this.Controls.Add( this.labA );
            this.Controls.Add( this.labC1 );
            this.Controls.Add( this.labText2 );
            this.Controls.Add( this.labText0 );
            this.Controls.Add( this.labText1 );
            this.Controls.Add( this.labD );
            this.Controls.Add( this.cmbScale );
            this.Controls.Add( this.cmbBias );
            this.Controls.Add( this.cmbB );
            this.Controls.Add( this.cmbC );
            this.Controls.Add( this.cmbA );
            this.Controls.Add( this.cmbOp );
            this.Controls.Add( this.cmbD );
            resources.ApplyResources( this, "$this" );
            this.Name = "MaterialPropertyTevDirectStageCalcPanel";
            this.ResumeLayout( false );

        }
        #endregion

        // 参照データ
        private TevDirectStage _refData = null;

        /// <summary>データ変更イベント。</summary>
        public event EventHandler DataChanged = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialPropertyTevDirectStageCalcPanel()
        {
            InitializeComponent();
        }

        /// <summary>
        /// 参照データ。
        /// </summary>
        public TevDirectStage RefData
        {
            set { _refData = value; }
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        public virtual void InitializeProperty()
        {
            // 引数
            // 項目作成は派生クラスで
            cmbA.SelectedIndexChanged += new EventHandler(Event_CmbA_SelectedIndexChanged);
            cmbB.SelectedIndexChanged += new EventHandler(Event_CmbB_SelectedIndexChanged);
            cmbC.SelectedIndexChanged += new EventHandler(Event_CmbC_SelectedIndexChanged);
            cmbD.SelectedIndexChanged += new EventHandler(Event_CmbD_SelectedIndexChanged);

            // 演算方法
            cmbOp.AddItem("+", AttrTevOp.Add);
            cmbOp.AddItem("-", AttrTevOp.Sub);
            cmbOp.SelectedIndexChanged += new EventHandler(Event_CmbOp_SelectedIndexChanged);

            // バイアス
            cmbBias.AddItem("- 0.5", AttrTevBias.SubHalf);
            cmbBias.AddItem("+ 0.0", AttrTevBias.Zero);
            cmbBias.AddItem("+ 0.5", AttrTevBias.AddHalf);
            cmbBias.SelectedIndexChanged += new EventHandler(Event_CmbBias_SelectedIndexChanged);

            // スケール
            cmbScale.AddItem("0.5", AttrTevScale.Divide2);
            cmbScale.AddItem("1.0", AttrTevScale.Scale1);
            cmbScale.AddItem("2.0", AttrTevScale.Scale2);
            cmbScale.AddItem("4.0", AttrTevScale.Scale4);
            cmbScale.SelectedIndexChanged += new EventHandler(Event_CmbScaleS_SelectedIndexChanged);

            // コンボボックス独自描画
            cmbA.DrawItem     += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbB.DrawItem     += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbC.DrawItem     += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbD.DrawItem     += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbOp.DrawItem    += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbBias.DrawItem  += OwnerDrawUtil.UIComboItemDrawHandler;
            cmbScale.DrawItem += OwnerDrawUtil.UIComboItemDrawHandler;

            const int dropDownW = 260;
            cmbA.DropDownWidth = dropDownW;
            cmbB.DropDownWidth = dropDownW;
            cmbC.DropDownWidth = dropDownW;
            cmbD.DropDownWidth = dropDownW;
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        public void UpdateProperty()
        {
            cmbA.SetSelectedItemData(_refData.A);
            cmbB.SetSelectedItemData(_refData.B);
            cmbC.SetSelectedItemData(_refData.C);
            cmbD.SetSelectedItemData(_refData.D);
            cmbOp.SetSelectedItemData(_refData.Op);
            cmbBias.SetSelectedItemData(_refData.Bias);
            cmbScale.SetSelectedItemData(_refData.Scale);

            UpdateArgCLabel();
        }

        /// <summary>
        /// 引数項目追加。
        /// </summary>
        protected void AddArgItem(string strID, AttrTevArg val)
        {
            cmbA.AddItem(strID, val, true);
            cmbB.AddItem(strID, val, true);
            cmbC.AddItem(strID, val, true);
            cmbD.AddItem(strID, val, true);
        }

        /// <summary>
        /// データ変更ハンドラ。
        /// </summary>
        protected virtual void OnDataChanged(EventArgs e)
        {
            if (this.DataChanged != null)
            {
                this.DataChanged(this, e);
            }
        }

        /// <summary>
        /// 引数Ｃラベルを更新。
        /// </summary>
        private void UpdateArgCLabel()
        {
            string text = cmbC.SelectedItem.ToString();

            // 制御文字で分割する
            int splitIndex = text.LastIndexOf(';');
            if( splitIndex != -1 )
            {
                text = text.Substring( 0, splitIndex );
            }

            // 更新
            labC.Text = text;
        }

        #region オーバーライド
        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }
        #endregion

        #region イベントハンドラ
        private void Event_CmbA_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.A = (AttrTevArg)cmbA.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbB_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.B = (AttrTevArg)cmbB.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbC_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdateArgCLabel();

            _refData.C = (AttrTevArg)cmbC.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbD_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.D = (AttrTevArg)cmbD.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbOp_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.Op = (AttrTevOp)cmbOp.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbBias_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.Bias = (AttrTevBias)cmbBias.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }

        private void Event_CmbScaleS_SelectedIndexChanged(object sender, EventArgs e)
        {
            _refData.Scale = (AttrTevScale)cmbScale.SelectedItemData;
            OnDataChanged(EventArgs.Empty);
        }
        #endregion
    }

    #region TevColorCalcStagePanel
    /// <summary>
    /// ＴＥＶカラー計算式ステージパネルクラス。
    /// </summary>
    public sealed class TevColorCalcStagePanel : MaterialPropertyTevDirectStageCalcPanel
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TevColorCalcStagePanel() {}

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override void InitializeProperty()
        {
            base.InitializeProperty();

            // 引数項目
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_RASC",  AttrTevArg.RasC);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_RASA",  AttrTevArg.RasA);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_TEXC",  AttrTevArg.TexC);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_TEXA",  AttrTevArg.TexA);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_C0",    AttrTevArg.C0);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A0",    AttrTevArg.A0);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_C1",    AttrTevArg.C1);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A1",    AttrTevArg.A1);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_C2",    AttrTevArg.C2);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A2",    AttrTevArg.A2);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_CPREV", AttrTevArg.CPrev);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_APREV", AttrTevArg.APrev);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_KONST", AttrTevArg.Konst);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_ONE",   AttrTevArg.One);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_HALF",  AttrTevArg.Half);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_ZERO",  AttrTevArg.Zero);
        }
    }
    #endregion

    #region TevAlphaCalcStagePanel
    /// <summary>
    /// ＴＥＶアルファ計算式ステージパネルクラス。
    /// </summary>
    public sealed class TevAlphaCalcStagePanel : MaterialPropertyTevDirectStageCalcPanel
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public TevAlphaCalcStagePanel() {}

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override void InitializeProperty()
        {
            base.InitializeProperty();

            // 引数項目
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_RASA",  AttrTevArg.RasA);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_TEXA",  AttrTevArg.TexA);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A0",    AttrTevArg.A0);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A1",    AttrTevArg.A1);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_A2",    AttrTevArg.A2);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_APREV", AttrTevArg.APrev);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_KONST", AttrTevArg.Konst);
            AddArgItem("PROP_MAT_TEV_STAGE_ARG_ZERO",  AttrTevArg.Zero);
        }
    }
    #endregion
}
