﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.PEControls
{
    using LayoutEditor.Controls;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters ;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures;
    using App = LayoutEditor;

    /// <summary>
    /// ＰＥブレンド設定パネルクラス。
    /// </summary>
    public sealed class PEBlendPanel : UserControl
    {
        #region デザイナ変数

        private App.Controls.UIRadioButton radModeNone;
        private App.Controls.UIRadioButton radModeBlend;
        private App.Controls.UIRadioButton radModeSubtract;
        private App.Controls.UIRadioButton radModeLogic;
        private App.Controls.BorderPanel pnlBlend;
        private System.ComponentModel.Container components = null;
        #endregion

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PEBlendPanel));
            this.radModeNone = new App.Controls.UIRadioButton();
            this.radModeBlend = new App.Controls.UIRadioButton();
            this.radModeSubtract = new App.Controls.UIRadioButton();
            this.radModeLogic = new App.Controls.UIRadioButton();
            this.pnlBlend = new App.Controls.BorderPanel();
            this.SuspendLayout();
            //
            // radModeNone
            //
            this.radModeNone.AccessibleDescription = resources.GetString("radModeNone.AccessibleDescription");
            this.radModeNone.AccessibleName = resources.GetString("radModeNone.AccessibleName");
            this.radModeNone.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("radModeNone.Anchor")));
            this.radModeNone.Appearance = ((System.Windows.Forms.Appearance)(resources.GetObject("radModeNone.Appearance")));
            this.radModeNone.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("radModeNone.BackgroundImage")));
            this.radModeNone.CheckAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeNone.CheckAlign")));
            this.radModeNone.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("radModeNone.Dock")));
            this.radModeNone.Enabled = ((bool)(resources.GetObject("radModeNone.Enabled")));
            this.radModeNone.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("radModeNone.FlatStyle")));
            this.radModeNone.Font = ((System.Drawing.Font)(resources.GetObject("radModeNone.Font")));
            this.radModeNone.Image = ((System.Drawing.Image)(resources.GetObject("radModeNone.Image")));
            this.radModeNone.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeNone.ImageAlign")));
            this.radModeNone.ImageIndex = ((int)(resources.GetObject("radModeNone.ImageIndex")));
            this.radModeNone.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("radModeNone.ImeMode")));
            this.radModeNone.Location = ((System.Drawing.Point)(resources.GetObject("radModeNone.Location")));
            this.radModeNone.Name = "radModeNone";
            this.radModeNone.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("radModeNone.RightToLeft")));
            this.radModeNone.Size = ((System.Drawing.Size)(resources.GetObject("radModeNone.Size")));
            this.radModeNone.TabIndex = ((int)(resources.GetObject("radModeNone.TabIndex")));
            this.radModeNone.Text = resources.GetString("radModeNone.Text");
            this.radModeNone.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeNone.TextAlign")));
            this.radModeNone.Visible = ((bool)(resources.GetObject("radModeNone.Visible")));
            //
            // radModeBlend
            //
            this.radModeBlend.AccessibleDescription = resources.GetString("radModeBlend.AccessibleDescription");
            this.radModeBlend.AccessibleName = resources.GetString("radModeBlend.AccessibleName");
            this.radModeBlend.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("radModeBlend.Anchor")));
            this.radModeBlend.Appearance = ((System.Windows.Forms.Appearance)(resources.GetObject("radModeBlend.Appearance")));
            this.radModeBlend.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("radModeBlend.BackgroundImage")));
            this.radModeBlend.CheckAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeBlend.CheckAlign")));
            this.radModeBlend.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("radModeBlend.Dock")));
            this.radModeBlend.Enabled = ((bool)(resources.GetObject("radModeBlend.Enabled")));
            this.radModeBlend.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("radModeBlend.FlatStyle")));
            this.radModeBlend.Font = ((System.Drawing.Font)(resources.GetObject("radModeBlend.Font")));
            this.radModeBlend.Image = ((System.Drawing.Image)(resources.GetObject("radModeBlend.Image")));
            this.radModeBlend.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeBlend.ImageAlign")));
            this.radModeBlend.ImageIndex = ((int)(resources.GetObject("radModeBlend.ImageIndex")));
            this.radModeBlend.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("radModeBlend.ImeMode")));
            this.radModeBlend.Location = ((System.Drawing.Point)(resources.GetObject("radModeBlend.Location")));
            this.radModeBlend.Name = "radModeBlend";
            this.radModeBlend.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("radModeBlend.RightToLeft")));
            this.radModeBlend.Size = ((System.Drawing.Size)(resources.GetObject("radModeBlend.Size")));
            this.radModeBlend.TabIndex = ((int)(resources.GetObject("radModeBlend.TabIndex")));
            this.radModeBlend.Text = resources.GetString("radModeBlend.Text");
            this.radModeBlend.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeBlend.TextAlign")));
            this.radModeBlend.Visible = ((bool)(resources.GetObject("radModeBlend.Visible")));
            //
            // radModeSubtract
            //
            this.radModeSubtract.AccessibleDescription = resources.GetString("radModeSubtract.AccessibleDescription");
            this.radModeSubtract.AccessibleName = resources.GetString("radModeSubtract.AccessibleName");
            this.radModeSubtract.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("radModeSubtract.Anchor")));
            this.radModeSubtract.Appearance = ((System.Windows.Forms.Appearance)(resources.GetObject("radModeSubtract.Appearance")));
            this.radModeSubtract.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("radModeSubtract.BackgroundImage")));
            this.radModeSubtract.CheckAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeSubtract.CheckAlign")));
            this.radModeSubtract.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("radModeSubtract.Dock")));
            this.radModeSubtract.Enabled = ((bool)(resources.GetObject("radModeSubtract.Enabled")));
            this.radModeSubtract.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("radModeSubtract.FlatStyle")));
            this.radModeSubtract.Font = ((System.Drawing.Font)(resources.GetObject("radModeSubtract.Font")));
            this.radModeSubtract.Image = ((System.Drawing.Image)(resources.GetObject("radModeSubtract.Image")));
            this.radModeSubtract.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeSubtract.ImageAlign")));
            this.radModeSubtract.ImageIndex = ((int)(resources.GetObject("radModeSubtract.ImageIndex")));
            this.radModeSubtract.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("radModeSubtract.ImeMode")));
            this.radModeSubtract.Location = ((System.Drawing.Point)(resources.GetObject("radModeSubtract.Location")));
            this.radModeSubtract.Name = "radModeSubtract";
            this.radModeSubtract.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("radModeSubtract.RightToLeft")));
            this.radModeSubtract.Size = ((System.Drawing.Size)(resources.GetObject("radModeSubtract.Size")));
            this.radModeSubtract.TabIndex = ((int)(resources.GetObject("radModeSubtract.TabIndex")));
            this.radModeSubtract.Text = resources.GetString("radModeSubtract.Text");
            this.radModeSubtract.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeSubtract.TextAlign")));
            this.radModeSubtract.Visible = ((bool)(resources.GetObject("radModeSubtract.Visible")));
            //
            // radModeLogic
            //
            this.radModeLogic.AccessibleDescription = resources.GetString("radModeLogic.AccessibleDescription");
            this.radModeLogic.AccessibleName = resources.GetString("radModeLogic.AccessibleName");
            this.radModeLogic.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("radModeLogic.Anchor")));
            this.radModeLogic.Appearance = ((System.Windows.Forms.Appearance)(resources.GetObject("radModeLogic.Appearance")));
            this.radModeLogic.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("radModeLogic.BackgroundImage")));
            this.radModeLogic.CheckAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeLogic.CheckAlign")));
            this.radModeLogic.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("radModeLogic.Dock")));
            this.radModeLogic.Enabled = ((bool)(resources.GetObject("radModeLogic.Enabled")));
            this.radModeLogic.FlatStyle = ((System.Windows.Forms.FlatStyle)(resources.GetObject("radModeLogic.FlatStyle")));
            this.radModeLogic.Font = ((System.Drawing.Font)(resources.GetObject("radModeLogic.Font")));
            this.radModeLogic.Image = ((System.Drawing.Image)(resources.GetObject("radModeLogic.Image")));
            this.radModeLogic.ImageAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeLogic.ImageAlign")));
            this.radModeLogic.ImageIndex = ((int)(resources.GetObject("radModeLogic.ImageIndex")));
            this.radModeLogic.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("radModeLogic.ImeMode")));
            this.radModeLogic.Location = ((System.Drawing.Point)(resources.GetObject("radModeLogic.Location")));
            this.radModeLogic.Name = "radModeLogic";
            this.radModeLogic.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("radModeLogic.RightToLeft")));
            this.radModeLogic.Size = ((System.Drawing.Size)(resources.GetObject("radModeLogic.Size")));
            this.radModeLogic.TabIndex = ((int)(resources.GetObject("radModeLogic.TabIndex")));
            this.radModeLogic.Text = resources.GetString("radModeLogic.Text");
            this.radModeLogic.TextAlign = ((System.Drawing.ContentAlignment)(resources.GetObject("radModeLogic.TextAlign")));
            this.radModeLogic.Visible = ((bool)(resources.GetObject("radModeLogic.Visible")));
            //
            // pnlBlend
            //
            this.pnlBlend.AccessibleDescription = resources.GetString("pnlBlend.AccessibleDescription");
            this.pnlBlend.AccessibleName = resources.GetString("pnlBlend.AccessibleName");
            this.pnlBlend.Anchor = ((System.Windows.Forms.AnchorStyles)(resources.GetObject("pnlBlend.Anchor")));
            this.pnlBlend.AutoScroll = ((bool)(resources.GetObject("pnlBlend.AutoScroll")));
            this.pnlBlend.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("pnlBlend.AutoScrollMargin")));
            this.pnlBlend.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("pnlBlend.AutoScrollMinSize")));
            this.pnlBlend.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("pnlBlend.BackgroundImage")));
            this.pnlBlend.Dock = ((System.Windows.Forms.DockStyle)(resources.GetObject("pnlBlend.Dock")));
            this.pnlBlend.Enabled = ((bool)(resources.GetObject("pnlBlend.Enabled")));
            this.pnlBlend.Font = ((System.Drawing.Font)(resources.GetObject("pnlBlend.Font")));
            this.pnlBlend.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("pnlBlend.ImeMode")));
            this.pnlBlend.Location = ((System.Drawing.Point)(resources.GetObject("pnlBlend.Location")));
            this.pnlBlend.Name = "pnlBlend";
            this.pnlBlend.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("pnlBlend.RightToLeft")));
            this.pnlBlend.Size = ((System.Drawing.Size)(resources.GetObject("pnlBlend.Size")));
            this.pnlBlend.TabIndex = ((int)(resources.GetObject("pnlBlend.TabIndex")));
            this.pnlBlend.Text = resources.GetString("pnlBlend.Text");
            this.pnlBlend.Visible = ((bool)(resources.GetObject("pnlBlend.Visible")));
            //
            // PEBlendPanel
            //
            this.AccessibleDescription = resources.GetString("$this.AccessibleDescription");
            this.AccessibleName = resources.GetString("$this.AccessibleName");
            this.AutoScroll = ((bool)(resources.GetObject("$this.AutoScroll")));
            this.AutoScrollMargin = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMargin")));
            this.AutoScrollMinSize = ((System.Drawing.Size)(resources.GetObject("$this.AutoScrollMinSize")));
            this.BackgroundImage = ((System.Drawing.Image)(resources.GetObject("$this.BackgroundImage")));
            this.Controls.Add(this.pnlBlend);
            this.Controls.Add(this.radModeLogic);
            this.Controls.Add(this.radModeSubtract);
            this.Controls.Add(this.radModeBlend);
            this.Controls.Add(this.radModeNone);
            this.Enabled = ((bool)(resources.GetObject("$this.Enabled")));
            this.Font = ((System.Drawing.Font)(resources.GetObject("$this.Font")));
            this.ImeMode = ((System.Windows.Forms.ImeMode)(resources.GetObject("$this.ImeMode")));
            this.Location = ((System.Drawing.Point)(resources.GetObject("$this.Location")));
            this.Name = "PEBlendPanel";
            this.RightToLeft = ((System.Windows.Forms.RightToLeft)(resources.GetObject("$this.RightToLeft")));
            this.Size = ((System.Drawing.Size)(resources.GetObject("$this.Size")));
            this.ResumeLayout(false);

        }
        #endregion

        // ブレンドパネル
        private readonly PECalcBlendPanel  _blendPanel;
        private readonly PELogicBlendPanel _logicPanel;

        // 編集用データ
        private readonly PEBlend _data = new PEBlend();

        /// <summary>データ変更イベント。</summary>
        public event EventHandler DataChanged = null;

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public PEBlendPanel()
        {
            InitializeComponent();

            // パネル作成
            _blendPanel         = new PECalcBlendPanel();
            _blendPanel.Parent  = pnlBlend;
            _blendPanel.Dock    = DockStyle.Fill;
            _blendPanel.Visible = false;
            _blendPanel.RefData = _data;

            _logicPanel         = new PELogicBlendPanel();
            _logicPanel.Parent  = pnlBlend;
            _logicPanel.Dock    = DockStyle.Fill;
            _logicPanel.Visible = false;
            _logicPanel.RefData = _data;
        }

        /// <summary>
        /// データ。
        /// </summary>
        public PEBlend Data
        {
            get { return _data; }
            set
            {
                // 設定をコピー
                _data.Set(value);

                // プロパティ更新
                UpdateProperty();
            }
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        public void InitializeProperty()
        {
            // モード
            radModeNone.Tag     = AttrBlendType.None;
            radModeBlend.Tag    = AttrBlendType.Blend;
            radModeLogic.Tag    = AttrBlendType.Logic;
            radModeSubtract.Tag = AttrBlendType.Subtract;

            radModeNone.RadioChecked     += new EventHandler(Event_RadMode_RadioChecked);
            radModeBlend.RadioChecked    += new EventHandler(Event_RadMode_RadioChecked);
            radModeLogic.RadioChecked    += new EventHandler(Event_RadMode_RadioChecked);
            radModeSubtract.RadioChecked += new EventHandler(Event_RadMode_RadioChecked);

            // ブレンドパネル
            _blendPanel.InitializeProperty();
            _logicPanel.InitializeProperty();
            _blendPanel.DataChanged += new EventHandler(Event_BlendPanel_DataChanged);
            _logicPanel.DataChanged += new EventHandler(Event_LogicPanel_DataChanged);
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        public void UpdateProperty()
        {
            // モード
            radModeNone.SetCheckedByTag(_data.Type);
            radModeBlend.SetCheckedByTag(_data.Type);
            radModeLogic.SetCheckedByTag(_data.Type);
            radModeSubtract.SetCheckedByTag(_data.Type);

            // ブレンドパネル
            switch (_data.Type)
            {
            case AttrBlendType.Blend:
                _logicPanel.Visible = false;
                _blendPanel.Visible = true;
                _blendPanel.UpdateProperty();
                break;
            case AttrBlendType.Logic:
                _blendPanel.Visible = false;
                _logicPanel.Visible = true;
                _logicPanel.UpdateProperty();
                break;
            default:
                _blendPanel.Visible = false;
                _logicPanel.Visible = false;
                break;
            }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose(bool disposing)
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// データ変更ハンドラ。
        /// </summary>
        private void OnDataChanged(EventArgs e)
        {
            if (this.DataChanged != null)
            {
                this.DataChanged(this, e);
            }
        }

        #region イベントハンドラ
        // モード
        private void Event_RadMode_RadioChecked(object sender, EventArgs e)
        {
            _data.Type = (AttrBlendType)((UIRadioButton)sender).Tag;
            UpdateProperty();
            OnDataChanged(EventArgs.Empty);
        }

        // ブレンド計算
        private void Event_BlendPanel_DataChanged(object sender, EventArgs e)
        {
            // 外に伝えるだけ
            OnDataChanged(EventArgs.Empty);
        }

        // 論理演算
        private void Event_LogicPanel_DataChanged(object sender, EventArgs e)
        {
            // 外に伝えるだけ
            OnDataChanged(EventArgs.Empty);
        }
        #endregion
    }
}
