﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using LECore.Util;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    /// <summary>
    /// マテリアル概要パネルクラス。
    /// </summary>
    public sealed class MaterialSummaryPanel : Panel
    {
        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialSummaryPanel()
        {
            this.SetStyle(ControlStyles.ResizeRedraw, true);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void OnPaint(PaintEventArgs e)
        {
            // 背景＆枠線
            e.Graphics.Clear(this.BackColor);
            GraphicsUtil.DrawRectangle(e.Graphics, SystemPens.ControlDark, this.ClientRectangle);
            base.OnPaint(e);
        }
    }
}
