﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;
using System.Windows.Forms;


using LECore;
using LECore.Structures.Nsrif.Attributes;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages
{

    using Utility;
    using Adapters;

    using LayoutEditor.Controls;

    /// <summary>
    /// インダイレクト行列を編集するページ
    /// </summary>
    public class MaterialIndirectMtxPage : MaterialPage
    {

       #region デザイナコード

        private System.Windows.Forms.RadioButton _radMtx1;
        private System.Windows.Forms.RadioButton _radMtx2;
        private System.Windows.Forms.GroupBox _grpTargetMtx;
        private System.Windows.Forms.RadioButton _radMtx0;
        private GroupBox _grpSRTMtx;
        private LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TextureControls.TextureSRTMtxEditPanel _pnlTexSRT;

        private void InitializeComponent()
        {
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager( typeof( MaterialIndirectMtxPage ) );
            this._radMtx1 = new System.Windows.Forms.RadioButton();
            this._radMtx2 = new System.Windows.Forms.RadioButton();
            this._grpTargetMtx = new System.Windows.Forms.GroupBox();
            this._radMtx0 = new System.Windows.Forms.RadioButton();
            this._grpSRTMtx = new System.Windows.Forms.GroupBox();
            this._pnlTexSRT = new LayoutEditor.Forms.ToolWindows.PropertyEditWindow.MaterialPages.TextureControls.TextureSRTMtxEditPanel();
            this._grpTargetMtx.SuspendLayout();
            this._grpSRTMtx.SuspendLayout();
            this.SuspendLayout();
            //
            // _radMtx1
            //
            resources.ApplyResources( this._radMtx1, "_radMtx1" );
            this._radMtx1.Name = "_radMtx1";
            this._radMtx1.CheckedChanged += new System.EventHandler( this.Event_RadMtx_CheckedChanged );
            //
            // _radMtx2
            //
            resources.ApplyResources( this._radMtx2, "_radMtx2" );
            this._radMtx2.Name = "_radMtx2";
            this._radMtx2.CheckedChanged += new System.EventHandler( this.Event_RadMtx_CheckedChanged );
            //
            // _grpTargetMtx
            //
            this._grpTargetMtx.Controls.Add( this._radMtx2 );
            this._grpTargetMtx.Controls.Add( this._radMtx1 );
            this._grpTargetMtx.Controls.Add( this._radMtx0 );
            resources.ApplyResources( this._grpTargetMtx, "_grpTargetMtx" );
            this._grpTargetMtx.Name = "_grpTargetMtx";
            this._grpTargetMtx.TabStop = false;
            //
            // _radMtx0
            //
            resources.ApplyResources( this._radMtx0, "_radMtx0" );
            this._radMtx0.Name = "_radMtx0";
            this._radMtx0.CheckedChanged += new System.EventHandler( this.Event_RadMtx_CheckedChanged );
            //
            // _grpSRTMtx
            //
            this._grpSRTMtx.Controls.Add( this._pnlTexSRT );
            resources.ApplyResources( this._grpSRTMtx, "_grpSRTMtx" );
            this._grpSRTMtx.Name = "_grpSRTMtx";
            this._grpSRTMtx.TabStop = false;
            //
            // _pnlTexSRT
            //
            resources.ApplyResources( this._pnlTexSRT, "_pnlTexSRT" );
            this._pnlTexSRT.MinimumSize = new System.Drawing.Size( 273, 147 );
            this._pnlTexSRT.Name = "_pnlTexSRT";
            this._pnlTexSRT.OnMatrixChanged += new System.EventHandler( this._pnlTexSRT_OnMatrixChanged );
            //
            // MaterialIndirectMtxPage
            //
            this.Controls.Add( this._grpSRTMtx );
            this.Controls.Add( this._grpTargetMtx );
            this.Name = "MaterialIndirectMtxPage";
            resources.ApplyResources( this, "$this" );
            this._grpTargetMtx.ResumeLayout( false );
            this._grpSRTMtx.ResumeLayout( false );
            this.ResumeLayout( false );

        }
        #endregion

        // 捜査対象インダイレクト行列
        TexIndirectMtx                 _targetTexIndMtx = null;


        /// <summary>
        /// 操作対象インダイレクト行列
        /// </summary>
        private TexIndirectMtx _TargetTexIndMtx
        {
            set
            {
                if( _targetTexIndMtx != value )
                {
                    _targetTexIndMtx = value;
                }
            }

            get
            {
                return _targetTexIndMtx;
            }
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public MaterialIndirectMtxPage()
        {
            InitializeComponent();
        }

        /// <summary>
        /// インスタンス作成。
        /// </summary>
        public static ObjPropertyPage CreateInstance(object arg)
        {
            ObjPropertyPage page = new MaterialIndirectMtxPage();
            return page;
        }

        /// <summary>
        /// プロパティ初期化。
        /// </summary>
        protected override void InitializeProperty()
        {
            _radMtx0.Checked = true;
        }

        /// <summary>
        /// プロパティ更新。
        /// </summary>
        protected override void UpdateProperty()
        {
            UpdateTragetTexture_();
        }

        #region イベントハンドラ

        /// <summary>
        /// 操作対象行列の更新
        /// </summary>
        void UpdateTragetTexture_()
        {
            if( ActiveTarget != null )
            {
                if( _radMtx0.Checked )
                {
                    _TargetTexIndMtx = ActiveTarget.TexIndirectMtxList[0];
                }
                else if( _radMtx1.Checked )
                {
                    _TargetTexIndMtx = ActiveTarget.TexIndirectMtxList[1];
                }
                else if( _radMtx2.Checked )
                {
                    _TargetTexIndMtx = ActiveTarget.TexIndirectMtxList[2];
                }
            }
            else
            {
                _TargetTexIndMtx = null;
            }

            if( _TargetTexIndMtx != null )
            {
                _pnlTexSRT.Enabled = true;
                // SRT行列変更パネルの対象にセット
                _pnlTexSRT.Set(
                    _TargetTexIndMtx.TexMtx.ScaleS,
                    _TargetTexIndMtx.TexMtx.ScaleT,
                    _TargetTexIndMtx.TexMtx.Rotate,
                    _TargetTexIndMtx.TexMtx.TransS,
                    _TargetTexIndMtx.TexMtx.TransT );
            }
            else
            {
                _pnlTexSRT.Enabled = false;
            }
        }

        /// <summary>
        /// 行列番号選択ボタン
        /// </summary>
        private void Event_RadMtx_CheckedChanged(object sender, System.EventArgs e)
        {
            UpdateTragetTexture_();
        }

        /// <summary>
        /// SRT パネル更新
        /// </summary>
        private void _pnlTexSRT_OnMatrixChanged( object sender, EventArgs e )
        {
            Debug.Assert( _TargetTexIndMtx != null );

            _TargetTexIndMtx.TexMtx.ScaleS = _pnlTexSRT.MtxScale.X;
            _TargetTexIndMtx.TexMtx.ScaleT = _pnlTexSRT.MtxScale.Y;

            _TargetTexIndMtx.TexMtx.Rotate = _pnlTexSRT.MtxRotate;

            _TargetTexIndMtx.TexMtx.TransS = _pnlTexSRT.MtxTrans.X;
            _TargetTexIndMtx.TexMtx.TransT = _pnlTexSRT.MtxTrans.Y;

            NotifyPropertyChanged();
        }
        #endregion イベントハンドラ



    }

}
