﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow
{
    using LayoutEditor.Controls;
    using LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters;

    using LECore.Manipulator;
    using LECore.Structures;
    using LECore.Save_Load;
    using LECore.Structures.Core;
    using Utility;
    using src.Controls;

    /// <summary>
    /// MaterialColorBlend の概要の説明です。
    /// </summary>
    public class MaterialColorBlendPage : MaterialPage
    {
        #region デザイナ変数
        private System.Windows.Forms.GroupBox grpCol1;
        private LayoutEditor.Controls.ColorEditPanel ctlColor1;
        private System.Windows.Forms.GroupBox grpCol0;
        private LayoutEditor.Controls.ColorEditPanel ctlColor0;
        private FlowLayoutPanel flowLayoutPanel1;
        private Label _lblNotice;
        private UICheckBox _chkDistanceFiledAlpha;
        #endregion
        private LayoutEditor.Controls.DockContentToolTip _ttpMain;
        private PictureBox _pctAlphaInterp;
        private Label _lblAlphaInterpDesc;
        private UICheckBox _cbxFloatColor;
        private src.Controls.BindAnimationLabel lblBlackColor;
        private src.Controls.BindAnimationLabel lblWhiteColor;
        private System.ComponentModel.IContainer components;

        #region デザイナコード
        /// <summary>
        /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
        /// コード エディタで変更しないでください。
        /// </summary>
        private void InitializeComponent()
        {
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(MaterialColorBlendPage));
            this.flowLayoutPanel1 = new System.Windows.Forms.FlowLayoutPanel();
            this._lblNotice = new System.Windows.Forms.Label();
            this._chkDistanceFiledAlpha = new LayoutEditor.Controls.UICheckBox();
            this._cbxFloatColor = new LayoutEditor.Controls.UICheckBox();
            this.grpCol0 = new System.Windows.Forms.GroupBox();
            this.ctlColor0 = new LayoutEditor.Controls.ColorEditPanel();
            this.grpCol1 = new System.Windows.Forms.GroupBox();
            this.ctlColor1 = new LayoutEditor.Controls.ColorEditPanel();
            this._pctAlphaInterp = new System.Windows.Forms.PictureBox();
            this._lblAlphaInterpDesc = new System.Windows.Forms.Label();
            this._ttpMain = new LayoutEditor.Controls.DockContentToolTip(this.components);
            this.lblBlackColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this.lblWhiteColor = new LayoutEditor.src.Controls.BindAnimationLabel();
            this.flowLayoutPanel1.SuspendLayout();
            this.grpCol0.SuspendLayout();
            this.grpCol1.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this._pctAlphaInterp)).BeginInit();
            this.SuspendLayout();
            //
            // flowLayoutPanel1
            //
            this.flowLayoutPanel1.Controls.Add(this._lblNotice);
            this.flowLayoutPanel1.Controls.Add(this._chkDistanceFiledAlpha);
            this.flowLayoutPanel1.Controls.Add(this._cbxFloatColor);
            this.flowLayoutPanel1.Controls.Add(this.grpCol0);
            this.flowLayoutPanel1.Controls.Add(this.grpCol1);
            this.flowLayoutPanel1.Controls.Add(this._pctAlphaInterp);
            this.flowLayoutPanel1.Controls.Add(this._lblAlphaInterpDesc);
            resources.ApplyResources(this.flowLayoutPanel1, "flowLayoutPanel1");
            this.flowLayoutPanel1.Name = "flowLayoutPanel1";
            //
            // _lblNotice
            //
            resources.ApplyResources(this._lblNotice, "_lblNotice");
            this._lblNotice.BackColor = System.Drawing.SystemColors.GradientActiveCaption;
            this._lblNotice.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
            this._lblNotice.Name = "_lblNotice";
            //
            // _chkDistanceFiledAlpha
            //
            resources.ApplyResources(this._chkDistanceFiledAlpha, "_chkDistanceFiledAlpha");
            this._chkDistanceFiledAlpha.Name = "_chkDistanceFiledAlpha";
            this._chkDistanceFiledAlpha.UseVisualStyleBackColor = true;
            this._chkDistanceFiledAlpha.CheckedChanged += new System.EventHandler(this.Event_chkDistanceFiledAlpha_CheckedChanged);
            //
            // _cbxFloatColor
            //
            resources.ApplyResources(this._cbxFloatColor, "_cbxFloatColor");
            this._cbxFloatColor.Name = "_cbxFloatColor";
            this._cbxFloatColor.UseVisualStyleBackColor = true;
            this._cbxFloatColor.CheckedChanged += new System.EventHandler(this.Event_cbxFloatColor_CheckedChanged);
            //
            // grpCol0
            //
            this.grpCol0.Controls.Add(this.ctlColor0);
            this.grpCol0.Controls.Add(this.lblBlackColor);
            this.grpCol0.FlatStyle = System.Windows.Forms.FlatStyle.System;
            resources.ApplyResources(this.grpCol0, "grpCol0");
            this.grpCol0.Name = "grpCol0";
            this.grpCol0.TabStop = false;
            //
            // ctlColor0
            //
            this.ctlColor0.AllowDrop = true;
            resources.ApplyResources(this.ctlColor0, "ctlColor0");
            this.ctlColor0.Name = "ctlColor0";
            this.ctlColor0.Tag = "";
            this.ctlColor0.UseAnimationMark = true;
            this.ctlColor0.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_CtlColor_BlackColorEdit);
            //
            // grpCol1
            //
            this.grpCol1.Controls.Add(this.ctlColor1);
            this.grpCol1.Controls.Add(this.lblWhiteColor);
            this.grpCol1.FlatStyle = System.Windows.Forms.FlatStyle.System;
            resources.ApplyResources(this.grpCol1, "grpCol1");
            this.grpCol1.Name = "grpCol1";
            this.grpCol1.TabStop = false;
            //
            // ctlColor1
            //
            this.ctlColor1.AllowDrop = true;
            resources.ApplyResources(this.ctlColor1, "ctlColor1");
            this.ctlColor1.Name = "ctlColor1";
            this.ctlColor1.Tag = "";
            this.ctlColor1.UseAnimationMark = true;
            this.ctlColor1.ColorEdit += new LayoutEditor.Controls.ColorEditEventHandler(this.Event_CtlColor_WhiteColorEdit);
            //
            // _pctAlphaInterp
            //
            resources.ApplyResources(this._pctAlphaInterp, "_pctAlphaInterp");
            this._pctAlphaInterp.Name = "_pctAlphaInterp";
            this._pctAlphaInterp.TabStop = false;
            //
            // _lblAlphaInterpDesc
            //
            this._lblAlphaInterpDesc.BackColor = System.Drawing.SystemColors.ControlLight;
            this._lblAlphaInterpDesc.ForeColor = System.Drawing.SystemColors.GrayText;
            resources.ApplyResources(this._lblAlphaInterpDesc, "_lblAlphaInterpDesc");
            this._lblAlphaInterpDesc.Name = "_lblAlphaInterpDesc";
            //
            // lblBlackColor
            //
            resources.ApplyResources(this.lblBlackColor, "lblBlackColor");
            this.lblBlackColor.Name = "lblBlackColor";
            //
            // lblWhiteColor
            //
            resources.ApplyResources(this.lblWhiteColor, "lblWhiteColor");
            this.lblWhiteColor.Name = "lblWhiteColor";
            //
            // MaterialColorBlendPage
            //
            this.Controls.Add(this.flowLayoutPanel1);
            this.Name = "MaterialColorBlendPage";
            resources.ApplyResources(this, "$this");
            this.flowLayoutPanel1.ResumeLayout(false);
            this.flowLayoutPanel1.PerformLayout();
            this.grpCol0.ResumeLayout(false);
            this.grpCol0.PerformLayout();
            this.grpCol1.ResumeLayout(false);
            this.grpCol1.PerformLayout();
            ((System.ComponentModel.ISupportInitialize)(this._pctAlphaInterp)).EndInit();
            this.ResumeLayout(false);

        }
        #endregion

        private readonly Image _imgThresholdingAlphaInterp = ImageResMgr.GetManifestResourcePng("ThresholdingAlphaInterp.png");
        private readonly Image _imgNormalAlphaInterp = ImageResMgr.GetManifestResourcePng("NormalAlphaInterp.png");

        /// <summary>
        /// コンストラクタ。
        /// </summary>
        public MaterialColorBlendPage()
        {
            InitializeComponent();

            if (RlytConverter.FloatColorWrite)
            {
                _cbxFloatColor.Show();
            }
            else
            {
                _cbxFloatColor.Hide();
            }

            // コンテキストメニューを追加する
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(lblBlackColor, ctlColor0.AnimationMarkArray);
            AnimationMarkContextMenuBuilder.BuildMultiControlMenu(lblWhiteColor, ctlColor1.AnimationMarkArray);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        public override PropertyPageID PageID
        {
            get { return PropertyPageID.MaterialColorBelnd; }
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void InitializeProperty()
        {
            // ViewManagerへのメッセージハンドラを設定します
            ctlColor0.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
            ctlColor1.SetViewManagerMessageHandler(this.Owner.SendMessageToViewManagerAction);
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void DoUpdateProperty_()
        {
            if( this.ActiveTarget == null )
            {
                return;
            }

            // アニメーションマークとコンテキストメニューの有効無効
            bool bUse = CanUseAnimationMark(this._OwnerPane.OwnerSubScene);
            IEnumerable<IAnimationMarkUsable> animCtrlList = GetAnimationMarkUsableControl();
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UseAnimationMark = bUse;
            }

            ctlColor0.Color = this.ActiveTarget.BlackColor;
            ctlColor1.Color = this.ActiveTarget.WhiteColor;

            _chkDistanceFiledAlpha.Enabled = this.ActiveTarget.IMaterial.OwnerPane.PaneKind != PaneKind.Textbox;
            _chkDistanceFiledAlpha.SetChecked(this.ActiveTarget.IsThresholdingAlphaInterpolationEnabled);
            _cbxFloatColor.SetChecked(!this.ActiveTarget.WhiteColor.ByteConvert);
            _pctAlphaInterp.BackgroundImage = this.ActiveTarget.IsThresholdingAlphaInterpolationEnabled ? _imgThresholdingAlphaInterp : _imgNormalAlphaInterp;
            _lblAlphaInterpDesc.Visible = this.ActiveTarget.IsThresholdingAlphaInterpolationEnabled;

            ctlColor0.IsAlphaEnabled = this.ActiveTarget.IsBlackColorAlphaEnabled;

            // 同時編集
            Color color = GetMultiEditColor();
            ctlColor0.TextBoxBackColor = color;
            ctlColor1.TextBoxBackColor = color;

            // 左上のマテリアル共有の設定によるパネルの有効/無効の設定
            this.Enabled = this.ActiveTarget.IsMaterialColorEditable;
            this._chkDistanceFiledAlpha.Enabled = this.Enabled;
            this._cbxFloatColor.Enabled = this.Enabled;
            this.ctlColor0.Enabled = this.Enabled;
            this.ctlColor1.Enabled = this.Enabled;

            this._lblNotice.Visible = !this.ActiveTarget.IsMaterialColorEditable;

            // アニメーションマークで利用するアトリビュートを関連付け
            ctlColor0.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetBlackColorIAnmAttr(Target));
            ctlColor1.SetTargetAttribute(PaneGuiAdapterGroupHelper.GetWhiteColorIAnmAttr(Target));

            // アニメーションマークの更新
            foreach (IAnimationMarkUsable ctrl in animCtrlList)
            {
                ctrl.UpdateAnimationMark();
            }
        }

        /// <summary>
        /// アニメーションマークが利用可能なコントロールの一覧を取得する。
        /// </summary>
        protected override IEnumerable<IAnimationMarkUsable> GetAnimationMarkUsableControl()
        {
            List<IAnimationMarkUsable> list = new List<IAnimationMarkUsable>();

            list.Add(lblBlackColor);
            list.Add(lblWhiteColor);
            list.Add(ctlColor0);
            list.Add(ctlColor1);

            return list;
        }

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override void Dispose( bool disposing )
        {
            if (disposing)
            {
                if (components != null)
                {
                    components.Dispose();
                }
            }
            base.Dispose(disposing);
        }

        #region コピー＆ペースト
        /// <summary>
        /// コピーが可能か。
        /// </summary>
        public override bool CanCopy() { return true; }
        //public override bool CanCopy(){ return false; }

        /// <summary>
        /// コピー。
        /// </summary>
        public override Object Copy()
        {
            return Copy(ActiveTarget);
        }

        /// <summary>
        /// コピー。
        /// </summary>
        public static Object Copy(MaterialGUIAdapter target)
        {
            List<object> data = new List<object>();
            return data;
        }

        /// <summary>
        /// ペースト。
        /// </summary>
        public override void Paste(Object pasteObject)
        {
            // Paste(ActiveTarget, pasteObject);
            Paste( ActiveTarget, pasteObject);
            using (new GUIUpdating(this))
            {
                UpdateProperty();
            }

            NotifyPropertyChanged();
        }


        /// <summary>
        /// ペースト。
        /// </summary>
        public static void Paste(MaterialGUIAdapter destination, Object pasteObject)
        {
        }
        #endregion

        #region イベントハンドラ
        /// <summary>
        /// 黒カラー編集
        /// </summary>
        private void Event_CtlColor_BlackColorEdit(object sender, LayoutEditor.Controls.ColorEditEventArgs e)
        {
            if (IsGUIUpdating) { return; }

            if (e.EditFixed)
            {
                EditColor( Target, e,
                           delegate( MaterialGUIAdapter adapter)
                           {
                               return adapter.BlackColor;
                           },
                           delegate( MaterialGUIAdapter adapter, FloatColor color)
                           {
                               adapter.BlackColor = color;
                           });
            }
        }

        /// <summary>
        /// 白カラー編集
        /// </summary>
        private void Event_CtlColor_WhiteColorEdit(object sender, LayoutEditor.Controls.ColorEditEventArgs e)
        {
            if (IsGUIUpdating) { return; }

            if (e.EditFixed)
            {
                EditColor( Target, e,
                           delegate( MaterialGUIAdapter adapter)
                           {
                               return adapter.WhiteColor;
                           },
                           delegate( MaterialGUIAdapter adapter, FloatColor color)
                           {
                               adapter.WhiteColor = color;
                           });
            }
        }

        private void Event_chkDistanceFiledAlpha_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            subScene.BeginMassiveModify();

            foreach (MaterialGUIAdapter adapter in this.ActiveTargets)
            {
                adapter.IsThresholdingAlphaInterpolationEnabled = _chkDistanceFiledAlpha.Checked;
            }

            subScene.EndMassiveModify();

            this.NotifyPropertyChanged();
        }

        private void Event_cbxFloatColor_CheckedChanged(object sender, EventArgs e)
        {
            if (IsGUIUpdating) { return; }

            UICheckBox cbx = (UICheckBox)sender;

            ISubScene subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            subScene.BeginMassiveModify();

            FloatColor newBlackColor = new FloatColor(ctlColor0.Color);
            newBlackColor.ByteConvert = !cbx.Checked;

            EditColor(Target, new ColorEditEventArgs(newBlackColor, true),
                delegate (MaterialGUIAdapter adapter)
                {
                    return adapter.BlackColor;
                },
                delegate (MaterialGUIAdapter adapter, FloatColor color)
                {
                    adapter.BlackColor = color;
                }
            );

            FloatColor newWhiteColor = new FloatColor(ctlColor1.Color);
            newWhiteColor.ByteConvert = !cbx.Checked;

            EditColor(Target, new ColorEditEventArgs(newWhiteColor, true),
                delegate (MaterialGUIAdapter adapter)
                {
                    return adapter.WhiteColor;
                },
                delegate (MaterialGUIAdapter adapter, FloatColor color)
                {
                    adapter.WhiteColor = color;
                }
            );

            subScene.EndMassiveModify();

            this.NotifyPropertyChanged();
        }
#endregion イベントハンドラ
    }
}
