﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Diagnostics;

namespace LayoutEditor.Forms.ToolWindows.PropertyEditWindow.Adapters
{
    using LECore.Structures;
    using LECore.Manipulator;
    using LECore.Structures.Nsrif.Attributes;

    public class MaskGUIAdapter : MaterialGUIAdapter
    {
        IMask _coreMask;

        public MaskGUIAdapter(IMask mask)
            : base(null)
        {
            _coreMask = mask;
            SetMaterialTexture_(_coreMask.MaskTexMap);
        }

        public TexMap TexMap
        {
            get
            {
                return TexMapList == null || TexMapList.TexMaps.Count == 0 ? null : TexMapList.SearchTexMapByTexMapID(0);
            }
        }

        public override IMaterial IMaterial
        {
            get
            {
                return _coreMask.InternalMaterial;
            }
        }

        public override bool HasSameTargets(object another)
        {
            MaskGUIAdapter anotherMask = another as MaskGUIAdapter;
            return (anotherMask != null && anotherMask._coreMask == this._coreMask);
        }

        public override void SetCoreDataToGUIMock()
        {
            TexMapList.TexMaps.Clear();
            SetMaterialTexture_(_coreMask.MaskTexMap);
        }

        public override void OnModified(PropertyPage sender, bool forcePushCommand)
        {
            // 多数の変更を行うことをシーンに通知します。
            LECore.LayoutEditorCore.Scene.CurrentISubScene.BeginMassiveModify();

            MaskManipulator maskMnp = new MaskManipulator();
            maskMnp.BindTarget(_coreMask);
            if (TexMapList.TexMaps != null && TexMapList.TexMaps.Count >= 1)
            {
                TexMap srcTexMap = TexMap;
                if (srcTexMap != null)
                {
                    TexImage srcTexImg = srcTexMap.TexImage;

                    // テクスチャの登録が無ければ新規に登録します。
                    RegisterTextureToTargetIfNeeded_(srcTexImg);

                    // ----------- TexImage の登録
                    // 新規登録テクスチャを発見したら、登録します。
                    IMaterialTexMap matTexMap = null;
                    if (srcTexImg != null && !MaskInternalMatarialHasTexture_(srcTexImg.Name))
                    {
                        AttrTextureResourceType resType = AttrTextureResourceType.LocalFile;
                        if (srcTexImg.Texture.SourceType == LECore.Structures.LECoreInterface.TextureSourceType.Dynamic)
                        {
                            resType = AttrTextureResourceType.LocalCaptured;

                            if (_coreMask.InternalMaterial.OwnerPane != null && _coreMask.InternalMaterial.OwnerPane.OwnerSubScene.IPartsLayout != null)
                            {
                                resType = AttrTextureResourceType.OverrideCaptured;
                            }
                        }
                        maskMnp.RegisterInternalMaterialTexture(
                            srcTexImg.Name,
                            resType);
                    }

                    // 各 GUI-TexMap の値をCoreSystem-TexMapにコピーします。
                    matTexMap = _coreMask.InternalMaterial.IMaterialTexMapSet[0];
                    Debug.Assert(matTexMap != null);
                    GUITexMapToCoreTexMap_(matTexMap, srcTexMap);
                }
            }
            else
            {
                // マテリアル・テクスチャを消去します。
                maskMnp.RemoveInternalMaterialTexture();
            }

            // 変更の終了をシーンに通知します。(変更イベントが発生します)
            LECore.LayoutEditorCore.Scene.CurrentISubScene.EndMassiveModify();
        }

        bool MaskInternalMatarialHasTexture_(string texName)
        {
            foreach (IMaterialTexMap coreTexMap in _coreMask.InternalMaterial.IMaterialTexMapSet)
            {
                if (coreTexMap.TexImgName == texName && coreTexMap.SlotIdx == 0)
                {
                    return true;
                }
            }
            return false;
        }
    }
}
