﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using LECore.Manipulator;
using LECore.Structures;

namespace LayoutEditor.Forms.ToolWindows.LayoutSettingWindow
{
    public partial class EnvironmentPage : LayoutSettingPage
    {
        public EnvironmentPage()
        {
            InitializeComponent();
        }

        private BackGround _targetBackGround = null;
        private BackGroundManipulator backGroundManipulator = new BackGroundManipulator();



        internal override void UpdateProperty()
        {
            var subScene = LECore.LayoutEditorCore.Scene.CurrentISubScene;
            if (subScene == null)
            {
                this.Enabled = false;
                return;
            }
            else
            {
                this.Enabled = true;
            }



            backGroundManipulator.BindTarget(LECore.LayoutEditorCore.Scene.CurrentISubScene.BackGround);
            _targetBackGround = subScene.BackGround;

            //------------ グリッドについて
            _chkDrawGrid.Checked = _targetBackGround.GridVisible;
            _ctlGridColor.Color = new FloatColor(_targetBackGround.GridColor);
            _tbxGridSize.Value = _targetBackGround.GridSize;
            _tbxDivisionNum.Value = (int)_targetBackGround.GridDivisionNum;

            _ctlScreenColorInside.Color = new FloatColor(_targetBackGround.BackGroundColor);


            _tbxWidth.Value = _targetBackGround.ScreenSize.X;
            _tbxHeight.Value = _targetBackGround.ScreenSize.Y;


            //------------ 背景画像について
            bool bBGImageEnabled = _targetBackGround.BackgroundImage != null;

            if (bBGImageEnabled)
            {
                _tbxImageName.Text = _targetBackGround.BackgroundImage.FilePath;
            }
            else
            {
                _tbxImageName.Text = string.Empty;
            }
        }

        private void _ctlScreenColorInside_ColorEdit(object sender, Controls.ColorEditEventArgs e)
        {
            backGroundManipulator.BackGroundColor = _ctlScreenColorInside.Color.ToSystemColor();
        }

        private void _chkDrawGrid_CheckedChanged(object sender, EventArgs e)
        {
            backGroundManipulator.GridVisible = _chkDrawGrid.Checked;
        }

        private void _ctlGridColor_ColorEdit(object sender, Controls.ColorEditEventArgs e)
        {
            backGroundManipulator.GridColor = _ctlGridColor.Color.ToSystemColor();
        }

        private void _tbxGridSize_ValueChanged(object sender, EventArgs e)
        {
            backGroundManipulator.GridSize = _tbxGridSize.Value;
        }

        private void _tbxDivisionNum_ValueChanged(object sender, EventArgs e)
        {
            backGroundManipulator.GridDivisionNum = (uint)_tbxDivisionNum.Value;
        }

        private void _tbxWidth_ValueChanged(object sender, EventArgs e)
        {
            if (_tbxWidth.Value != _targetBackGround.ScreenSize.X)
            {
                backGroundManipulator.ScreenSize = new LECore.Structures.FVec2(_tbxWidth.Value, _targetBackGround.ScreenSize.Y);

                // アプリケーション設定に保存
                OwnerToolWindow.ViewManager.AppSetting.LastSetScreenSize = _targetBackGround.ScreenSize.AsPointF;
            }
        }

        private void _tbxHeight_ValueChanged(object sender, EventArgs e)
        {
            if (_tbxHeight.Value != _targetBackGround.ScreenSize.Y)
            {
                backGroundManipulator.ScreenSize = new LECore.Structures.FVec2(_targetBackGround.ScreenSize.X, _tbxHeight.Value);

                // アプリケーション設定に保存
                OwnerToolWindow.ViewManager.AppSetting.LastSetScreenSize = _targetBackGround.ScreenSize.AsPointF;
            }
        }

        private void _btnLoadImage_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd = new OpenFileDialog();

            ofd.Filter = "tga files (*.tga)|*.tga";
            ofd.RestoreDirectory = true;
            ofd.FileName = _tbxImageName.Text;

            if (ofd.ShowDialog() == DialogResult.OK)
            {
                var textureImage = TextureImageFactory.BuildTextureImageFromTga(ofd.FileName);
                if (textureImage != null)
                {
                    backGroundManipulator.BackgroundImage = textureImage;
                }
            }
        }

        private void _btnRemoveImage_Click(object sender, EventArgs e)
        {
            backGroundManipulator.BackgroundImage = null;
        }

        private void _tbxImageName_ValueChanged(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(_tbxImageName.Value))
            {
                backGroundManipulator.BackgroundImage = null;
            }
            else
            {
                var textureImage = TextureImageFactory.BuildTextureImageFromTga(_tbxImageName.Value);
                if (textureImage != null)
                {
                    backGroundManipulator.BackgroundImage = textureImage;
                }
            }
        }

    }
}
