﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace LayoutEditor.Controls.UI
{
    /// <summary>
    /// コンテキストメニューでアイテムの表示非表示を切り替えることが可能な、
    /// StatusStrip
    /// </summary>
    public partial class UIStatusStrip : StatusStrip
    {
        //------------------------------------------------
        // フィールド

        // コンテキストメニュー
        ContextMenuStrip _contextMenuStrip = new ContextMenuStrip();



        /// <summary>
        /// コンテキストメニューに項目を登録します。
        /// </summary>
        void RegisterContextMenuItem_( ToolStripItem item, string description )
        {
            ToolStripMenuItem tmi = new ToolStripMenuItem( description );
            tmi.Tag = item;
            tmi.Click += new EventHandler( ContextMenuItem_Click_ );

            _contextMenuStrip.Items.Add( tmi );
        }

        /// <summary>
        /// コンテキストメニュークリックハンドラ
        /// </summary>
        void ContextMenuItem_Click_( object sender, EventArgs e )
        {
            ToolStripMenuItem tmi = sender as ToolStripMenuItem;
            ToolStripItem tsi = tmi.Tag as ToolStripItem;

            tsi.Visible = !tsi.Visible;

            tmi.Checked = tsi.Visible;
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public UIStatusStrip()
        {
            InitializeComponent();
            this.ContextMenuStrip = _contextMenuStrip;
        }



        /// <summary>
        /// 表示切替をしたいアイテムを登録します。
        /// ステータスバーを保持するクラスのコンストラクタなどで
        /// 呼び出されることを想定しています。
        /// </summary>
        public void RegisterToolItemAsVisibleChangable( ToolStripItem item, string description )
        {
            RegisterContextMenuItem_( item, description );

            if( !this.Items.Contains( item ) )
            {
                this.Items.Add( item );
            }
        }


    }
}
