﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace LayoutEditor.Controls
{
    using System;
    using System.Runtime.InteropServices;
    using System.Windows.Forms;
    using LECore.Win32;

    /// <summary>
    ///
    /// </summary>
    public static class OverlayIconHelper
    {
        public const int TVIF_STATE = 0x0008;
        public const int TVIS_OVERLAYMASK = 0x0F00;
        public const int TVM_SETITEMW = 0x113F;
        public const int LVSIL_SMALL = 1;
        public const int LVIS_OVERLAYMASK = 0x0F00;

        [DllImport("comctl32.dll")]
        public static extern int ImageList_SetOverlayImage(IntPtr himl, int iImage, int iOverlay);

        /// <summary>
        /// TreeNode にオーバーレイアイコンを表示。
        /// </summary>
        public static void TreeViewOverlay(TreeNode node, uint overlayIndex)
        {
            TVITEM tvi = new TVITEM();
            tvi.mask = TVIF_STATE;
            tvi.hItem = node.Handle;
            tvi.stateMask = TVIS_OVERLAYMASK;
            tvi.state = (overlayIndex << 8);
            LECore.Win32.User32.SendMessage(node.TreeView.Handle, TVM_SETITEMW, 0, ref tvi);
        }

        /// <summary>
        /// ListView にオーバーレイアイコンを表示。
        /// </summary>
        public static void ListViewOverlay(ListViewItem listItem, uint overlayIndex)
        {
            LVITEM lvi = new LVITEM();
            lvi.stateMask = LVIS_OVERLAYMASK;
            lvi.state = (overlayIndex << 8);
            LECore.Win32.User32.SendMessage(listItem.ListView.Handle, LVM.LVM_SETITEMSTATE, listItem.Index, ref lvi);
        }

    }
}
