float4x4 view_model_matrix;
float4x4 world_matrix;

float4x4 texture_matrix0;
float4x4 texture_matrix1;
float4x4 texture_matrix2;

float4x4 texProjectionMtx0;
float4x4 texProjectionMtx1;
float4x4 texProjectionMtx2;

int isTexProjection0 = 0;
int isTexProjection1 = 0;
int isTexProjection2 = 0;

struct VS_OUTPUT
{
   float4 Pos     : POSITION;
   float4 PCol    : COLOR0;
   float4 PTex0   : TEXCOORD0;
   float4 PTex1   : TEXCOORD1;
   float4 PTex2   : TEXCOORD2;
   float4 PLocalPos : TEXCOORD3;
};

VS_OUTPUT main (float4 vPosition : POSITION, float4 vDiffuse : COLOR0, float4 vTex0 : TEXCOORD0, float4 vTex1 : TEXCOORD1, float4 vTex2 : TEXCOORD2, float4 vLocalPos : TEXCOORD3)
{
   VS_OUTPUT Out = (VS_OUTPUT) 0; 

   Out.Pos = mul (view_model_matrix, vPosition);
   
   float4 texCoord0 = vTex0;
   if(isTexProjection0 == 1)
   {
        texCoord0 = mul (world_matrix, vPosition);
        texCoord0 = mul (texProjectionMtx0, texCoord0);
   }
   
   float4 texCoord1 = vTex1;
   if(isTexProjection1 == 1)
   {
        texCoord1 = mul (world_matrix, vPosition);
        texCoord1 = mul (texProjectionMtx1, texCoord1);
   }
   
   float4 texCoord2 = vTex2;
   if(isTexProjection2 == 1)
   {
        texCoord2 = mul (world_matrix, vPosition);
        texCoord2 = mul (texProjectionMtx2, texCoord2);
   }

   Out.PCol = vDiffuse;
   Out.PTex0 = mul(texCoord0, texture_matrix0);
   Out.PTex1 = mul(texCoord1, texture_matrix1);
   Out.PTex2 = mul(texCoord2, texture_matrix2);
   Out.PLocalPos = vLocalPos;
   
   return Out;
}
