﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace LECore.Structures
{
    /// <summary>
    /// 部品サブシーンです。
    /// <remarks>
    /// 実際の読み込みは遅延されます。
    /// 部品として読み込まれた際に、ツール内部でキャッシュされます。
    /// 通常のレイアウトとして読み込まれた場合はキャッシュされません。
    /// </remarks>
    /// </summary>
    public interface IPartsSubScene
    {
        string FilePath { get; }
        bool IsLoaded { get; }
        ISubScene SubScene { get; }

        string PartsKind { get; }
        string Description { get; }
        string DescriptionName { get; }

        int TotalPaneCount { get; }
        int TotalPixelCount { get; }

        bool IsValidPartsSubScene { get; }

        IEnumerable<string> ControlNames { get; }

        string BasePartsName { get; }
        DateTime BasePartsLastModify { get; }
        bool IsBasePartsSubSceneModified { get; }
    }
}
