﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;

namespace LECore.Structures
{
    /// <summary>
    /// グループメンバを巡回して実行されるハンドラ
    /// </summary>
    public delegate bool LEGroupTraverseHandler( ILEGroup owner, ILEGroup member, object args );

    /// <summary>
    /// グループのヘルパ
    /// </summary>
    public static class LEGroupHelper
    {
        /// <summary>
        /// ペイン名が同一のメンバがいるか
        /// </summary>
        public static bool ContainsPaneName(this ILEGroup group, string paneName)
        {
            return Array.Exists(group.Member, (member) => member.PaneName == paneName);
        }
    }

    /// <summary>
    /// グループ外部公開インタフェース
    /// </summary>
    public interface ILEGroup
    {
        /// <summary>
        /// グループメンバを取得する、メンバがいない場合は、長さゼロの配列が返ります。
        /// </summary>
        IPane[] Member { get; }
        /// <summary>
        /// グループメンバを持つか？
        /// </summary>
        bool HasMember { get; }
        /// <summary>
        /// グループ要素の名前
        /// </summary>
        string GrouprName { get; }

        /// <summary>
        /// ユーザコメント
        /// </summary>
        string UserCommentString { get; }

        /// <summary>
        /// ペインがメンバか調査します。
        /// </summary>
        bool Contains( IPane pane );

        /// <summary>
        /// 読み取り専用か？
        /// </summary>
        bool IsReadOnlyLocked { get; }
    }
}
