﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using LECore.Structures.LECoreInterface;

namespace LECore.Structures
{
    using Core;
    using LECore.Structures.Nsrif.Attributes;

    public interface IDropShadow
    {
        IPane OwnerPane
        {
            get;
        }

        bool IsDropShadowEtcEnabled
        {
            get;
        }

        bool IsKnockoutEnabled
        {
            get;
        }

        bool IsOnlyEffectEnabled
        {
            get;
        }

        bool IsStaticRenderingEnabled
        {
            get;
        }

        bool IsStrokeEnabled
        {
            get;
        }

        float strokeSize
        {
            get;
        }

        DropShadowBlendMode strokeBlendMode
        {
            get;
        }

        RGBAColor strokeColor
        {
            get;
        }

        bool IsOuterGlowEnabled
        {
            get;
        }

        DropShadowBlendMode outerGlowBlendMode
        {
            get;
        }

        RGBAColor outerGlowColor
        {
            get;
        }

        float outerGlowSpread
        {
            get;
        }

        float outerGlowSize
        {
            get;
        }

        bool IsDropShadowEnabled
        {
            get;
        }

        DropShadowBlendMode dropShadowBlendMode
        {
            get;
        }

        RGBAColor dropShadowColor
        {
            get;
        }

        float dropShadowAngle
        {
            get;
        }

        float dropShadowDistance
        {
            get;
        }

        float dropShadowSpread
        {
            get;
        }

        float dropShadowSize
        {
            get;
        }

        IAnmAttribute IStrokeSizeAttr
        {
            get;
        }

        IAnmAttribute IStrokeColorAttr
        {
            get;
        }

        IAnmAttribute IOuterGlowColorAttr
        {
            get;
        }

        IAnmAttribute IOuterGlowSpreadAttr
        {
            get;
        }

        IAnmAttribute IOuterGlowSizeAttr
        {
            get;
        }

        IAnmAttribute IDropShadowColorAttr
        {
            get;
        }

        IAnmAttribute IDropShadowAngleAttr
        {
            get;
        }

        IAnmAttribute IDropShadowDistanceAttr
        {
            get;
        }

        IAnmAttribute IDropShadowSpreadAttr
        {
            get;
        }

        IAnmAttribute IDropShadowSizeAttr
        {
            get;
        }
    }
}
