﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;

namespace LECore.Structures
{
    static public class LEMath
    {
        public const int InvalidDecimalNum = -1000;

        /// <summary>
        /// 小数点桁数を取得します。
        /// </summary>
        static public int CalcDecimals( float val )
        {
            float absVal = Math.Abs( val );

            return ( absVal > float.Epsilon ) ?
                Math.Max( 0, -(int)Math.Floor( Math.Log10( absVal ) ) ) : InvalidDecimalNum;
        }

        /// <summary>
        /// 小数点以下を丸めます。
        /// </summary>
        static public float ToRoundDownDecimals( double dValue, int iDecimals )
        {
            double result = dValue;
            if( iDecimals != InvalidDecimalNum )
            {
                double dCoef = System.Math.Pow( 10, iDecimals );
                result = System.Math.Round( dValue * dCoef ) / dCoef;
            }
            return (float)result;
        }

    }
}
