﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Diagnostics;
using System.Text.RegularExpressions;

namespace LECore.Structures
{
    /// <summary>
    /// GroupHelper の概要の説明です。
    /// </summary>
    static public class GroupHelper
    {
        public const string RootGroupName = "RootGroup";

        /// <summary>
        /// ルートグループか？
        /// </summary>
        static public bool IsRootGroup(this ILEGroup group)
        {
            return group.GrouprName == RootGroupName;
        }

        /// <summary>
        /// シーン内で重複しない適切なグループ名を取得します。
        /// </summary>
        static public string GetUniqueGroupName(ILEGroupMgr groupMgr, string originalGroupName)
        {
            return SubSceneHelper.GetValidName(groupMgr.FindGroupByName, AppConstants.MaxGroupNameLength, originalGroupName);
        }

        /// <summary>
        /// グループ名が敵適切か判定します。
        /// </summary>
        static public bool CheckGroupNameValid( string name )
        {
            if( name != RootGroupName )
            {
                if( name.Length > 0 && name.Length <= LECore.AppConstants.MaxGroupNameLength )
                {
                    Match m = LECore.AppConstants.RegexInvalidCharForObjName.Match( name );
                    if( m.Length == 0 )
                    {
                        return true;
                    }
                }
            }
            return false;
        }
    }
}
