﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Linq;
using System.Diagnostics;
using System.Text;
using System.Threading.Tasks;

namespace LECore.Save_Load
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;
    using AppData = LECore.Structures;
    using FileFmt = LECore.Structures.SerializableObject.Lyt;

    public partial class RlytConverter
    {
        #region File => App
        void Convert_Pane_Mask_(AppData.Mask dstMask, FileFmt.Mask srcMask)
        {
            if (srcMask == null)
            {
                dstMask.IsMaskEnabled = false;
                return;
            }

            dstMask.IsMaskEnabled = srcMask.maskEnabled;
            dstMask.IsMaskWithPane = srcMask.maskWithPane;

            {
                AppData.Material dstMaterial = dstMask.InternalMaterial as AppData.Material;
                dstMaterial.RemoveMatTextureAllNoEvent();

                AppData.MaterialTexMap dstMaskTexMap = dstMaterial.GetMaterialTexMapByIndex(0);
                Debug.Assert(dstMaskTexMap != null);

                FileFmt.TexMap srcMaskTexMap = srcMask.maskTexMap;
                dstMaskTexMap = dstMaterial.RegisterMatTexture(srcMaskTexMap.imageName, 0, (AttrTextureResourceType)srcMaskTexMap.textureResourceType);

                dstMaskTexMap.MagFilter = (AttrTexFilterMag)srcMaskTexMap.magFilter;
                dstMaskTexMap.MinFilter = (AttrTexFilterMin)srcMaskTexMap.minFilter;
                dstMaskTexMap.WrapS = (AttrTexWrap)srcMaskTexMap.wrap_s;
                dstMaskTexMap.WrapT = (AttrTexWrap)srcMaskTexMap.wrap_t;
                dstMaskTexMap.ResourceType = (AttrTextureResourceType)srcMaskTexMap.textureResourceType;

                AppData.TexMtx dstMtx = dstMaterial.TexMtxSet[0];
                FileFmt.TexMatrix srcMtx = srcMask.maskTexMatrix;
                dstMtx.Trans = new FVec2(srcMtx.translate.x, srcMtx.translate.y);
                dstMtx.Scale = new FVec2(srcMtx.scale.x, srcMtx.scale.y);
                dstMtx.Rotate = srcMtx.rotate;
            }
        }
        #endregion

        #region App => File

        FileFmt.Mask Convert_ToFile_Mask_(AppData.IMask srcMask)
        {
            if (!srcMask.IsMaskEnabled)
            {
                return null;
            }

            FileFmt.Mask dstMask = new FileFmt.Mask();
            dstMask.maskEnabled = srcMask.IsMaskEnabled;
            dstMask.maskWithPane = srcMask.IsMaskWithPane;

            var srcMaskTexMap = srcMask.MaskTexMap;
            FileFmt.TexMap dstMaskTexMap = new FileFmt.TexMap();
            dstMaskTexMap.wrap_s = (FileFmt.TexWrapMode)srcMaskTexMap.WrapS;
            dstMaskTexMap.wrap_t = (FileFmt.TexWrapMode)srcMaskTexMap.WrapT;
            dstMaskTexMap.imageName = srcMaskTexMap.TexImgName;
            dstMaskTexMap.minFilter = (FileFmt.TexFilter)srcMaskTexMap.MinFilter;
            dstMaskTexMap.magFilter = (FileFmt.TexFilter)srcMaskTexMap.MagFilter;
            dstMaskTexMap.textureResourceType = (FileFmt.TextureResourceType)srcMaskTexMap.ResourceType;
            dstMask.maskTexMap = dstMaskTexMap;

            var srcMaskTexMtx = srcMask.MaskTexMatrix;
            FileFmt.TexMatrix dstMaskTexMtx = new FileFmt.TexMatrix();
            dstMaskTexMtx.translate = Convert_Vec2_(srcMaskTexMtx.Trans);
            dstMaskTexMtx.scale = Convert_Vec2_(srcMaskTexMtx.Scale);
            dstMaskTexMtx.rotate = srcMaskTexMtx.Rotate;
            dstMask.maskTexMatrix = dstMaskTexMtx;

            FileFmt.TexMap dstCaptureTexMap = new FileFmt.TexMap();
            dstCaptureTexMap.wrap_s = FileFmt.TexWrapMode.Clamp;
            dstCaptureTexMap.wrap_t = FileFmt.TexWrapMode.Clamp;

            // サフィックスを付加する拡張前との互換性維持のため、マスク用キャプチャテクスチャにペイン名と同じ名前が設定されていたらサフィックスを付加しないで出力する。
            string texNameWithSuffix = srcMask.OwnerPane.PaneName + CaptureTexture.GetNameSuffix(CaptureTextureUsage.Mask);
            ITextureImage newNameTex = srcMask.OwnerPane.OwnerSubScene.ITextureMgr.FindITextureImageByName(texNameWithSuffix);
            ITextureImage oldNameTex = srcMask.OwnerPane.OwnerSubScene.ITextureMgr.FindITextureImageByName(srcMask.OwnerPane.PaneName);

            // マスク用のサフィックス付きキャプチャテクスチャが作成されていないかつペイン名と同じテクスチャが存在した場合は旧仕様のデータと判断してサフィックスを付加しない。
            if (newNameTex == null &&
                oldNameTex != null &&
                oldNameTex.ICaptureTexture != null)
            {
                dstCaptureTexMap.imageName = srcMask.OwnerPane.PaneName;
            }
            else
            {
                dstCaptureTexMap.imageName = texNameWithSuffix;
            }
            dstCaptureTexMap.minFilter = FileFmt.TexFilter.Linear;
            dstCaptureTexMap.magFilter = FileFmt.TexFilter.Linear;
            dstCaptureTexMap.textureResourceType = FileFmt.TextureResourceType.LocalCaptured;
            dstMask.captureTexMap = dstCaptureTexMap;

            return dstMask;
        }

        #endregion

        internal AppData.Mask Convert_Pane_MaskSelf(AppData.Pane dstPane, FileFmt.Mask srcMask)
        {
            AppData.Mask mask = new Structures.Mask(dstPane);
            Convert_Pane_Mask_(mask, srcMask);
            return mask;
        }

        internal FileFmt.Mask Convert_Item_MaskSelf(AppData.IMask srcMask)
        {
            return Convert_ToFile_Mask_(srcMask);
        }
    }
}
