﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Diagnostics;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Structures.Nsrif.Attributes;
    using LECore.Structures.Core.Command;

    using TextureChangerCommandFactory = LECore.Structures.Core.Command.MementoCommandFactory<LECore.Structures.TextureChanger>;

    /// <summary>
    /// MaterialManipulator の概要の説明です。
    /// </summary>
    public class TextureChangerManipulator
    {
        /// 操作対象
        TextureChanger          _target = null;

        ///
        private TextureChangerCommandFactory commandFactory = null;

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public TextureChangerManipulator()
        {
            this.commandFactory = new TextureChangerCommandFactory
                ( delegate( TextureChanger textureChanger)
                        {
                            return new TextureChangerMemento( textureChanger);
                        });
        }

        /// <summary>
        /// 操作対象を設定します。
        /// </summary>
        /// <param name="targetTextBox"></param>
        public void BindTarget( ITextureChanger textureChanger )
        {
            _target = textureChanger as TextureChanger;
            Debug.Assert( _target != null );
        }

        /// <summary>
        /// セットを設定します。
        /// </summary>
        public void SetAll( string[] texNameSet )
        {
            TextureSubSet       textureSubSet = _target.TextureSubSet;
            if( !textureSubSet.IsSameSet( texNameSet ) )
            {
                this.commandFactory.Modify
                    ( _target,
                      delegate()
                          {
                              textureSubSet.Clear();
                              textureSubSet.AddTextures( texNameSet );
                              _target.Evaluate();
                          } );
            }
        }
    }
}
