﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using LECore.Structures.LECoreInterface;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Structures.Core.Command;
    using LECore.Structures.Nsrif.Attributes;

    using ProceduralShapeCommandFactory = LECore.Structures.Core.Command.MementoCommandFactory<LECore.Structures.IProceduralShape>;

    public class ProceduralShapeManipulator : BaseManipulator
    {
        ProceduralShape _target = null;
        ProceduralShapeCommandFactory _commandFactory;

        public ProceduralShapeManipulator()
        {
            _commandFactory = new ProceduralShapeCommandFactory
                (
                delegate (IProceduralShape mementoSrc) { return new ProceduralShapeMemento(mementoSrc); }
                );
        }

        public void BindTarget(IProceduralShape target)
        {
            _target = target as ProceduralShape;
            System.Diagnostics.Debug.Assert(_target != null);
        }

        public IProceduralShape IProceduralShape
        {
            get
            {
                return _target;
            }
        }

        #region 角丸

        public bool IsProceduralShapeEnabled
        {
            set
            {
                if (_target.IsProceduralShapeEnabled != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.IsProceduralShapeEnabled = value;
                    });
                }
            }
        }

        public float Exp
        {
            set
            {
                if (_target.Exp != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.Exp = value;
                    });
                }
            }
        }

        public float Radius
        {
            set
            {
                if (_target.Radius != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.Radius = value;
                    });
                }
            }
        }

        #endregion

        #region 境界線(内側)

        public bool IsInnerStrokeEnabled
        {
            set
            {
                if (_target.IsInnerStrokeEnabled != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.IsInnerStrokeEnabled = value;
                    });
                }
            }
        }

        public float InnerStrokeSize
        {
            set
            {
                if (_target.InnerStrokeSize != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.InnerStrokeSize = value;
                    });
                }
            }
        }

        public ProceduralShapeEffectBlendMode InnerStrokeBlendMode
        {
            set
            {
                if (_target.InnerStrokeBlendMode != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.InnerStrokeBlendMode = value;
                    });
                }
            }
        }

        public RGBAColor InnerStrokeColor
        {
            set
            {
                if (_target.InnerStrokeColor != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.InnerStrokeColor = value;
                    });
                }
            }
        }

        #endregion

        #region ドロップシャドウ(内側)

        public bool IsInnerShadowEnabled
        {
            set
            {
                if (_target.IsInnerShadowEnabled != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.IsInnerShadowEnabled = value;
                    });
                }
            }
        }

        public ProceduralShapeEffectBlendMode InnerShadowBlendMode
        {
            set
            {
                if (_target.InnerShadowBlendMode != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.InnerShadowBlendMode = value;
                    });
                }
            }
        }

        public RGBAColor InnerShadowColor
        {
            set
            {
                if (_target.InnerShadowColor != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.InnerShadowColor = value;
                    });
                }
            }
        }

        public float InnerShadowAngle
        {
            set
            {
                if (_target.InnerShadowAngle != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.InnerShadowAngle = value;
                    });
                }
            }
        }

        public float InnerShadowDistance
        {
            set
            {
                if (_target.InnerShadowDistance != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.InnerShadowDistance = value;
                    });
                }
            }
        }

        public float InnerShadowSize
        {
            set
            {
                if (_target.InnerShadowSize != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.InnerShadowSize = value;
                    });
                }
            }
        }

        public ProceduralShapeShadowType InnerShadowType
        {
            set
            {
                if (_target.InnerShadowType != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.InnerShadowType = value;
                    });
                }
            }
        }

        #endregion

        #region カラーオーバーレイ

        public bool IsColorOverayEnabled
        {
            set
            {
                if (_target.IsColorOverayEnabled != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.IsColorOverayEnabled = value;
                    });
                }
            }
        }

        public ProceduralShapeEffectBlendMode ColorOverlayBlendMode
        {
            set
            {
                if (_target.ColorOverlayBlendMode != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.ColorOverlayBlendMode = value;
                    });
                }
            }
        }

        public RGBAColor ColorOverlayColor
        {
            set
            {
                if (_target.ColorOverlayColor != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.ColorOverlayColor = value;
                    });
                }
            }
        }

        #endregion

        #region グラデーションオーバーレイ

        public bool IsGradationOverayEnabled
        {
            set
            {
                if (_target.IsGradationOverayEnabled != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.IsGradationOverayEnabled = value;
                    });
                }
            }
        }

        public ProceduralShapeEffectBlendMode GradationOverlayBlendMode
        {
            set
            {
                if (_target.GradationOverlayBlendMode != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.GradationOverlayBlendMode = value;
                    });
                }
            }
        }

        public int GradationOverlayControlPointCount
        {
            set
            {
                if (_target.GradationOverlayControlPointCount != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.GradationOverlayControlPointCount = value;
                    });
                }
            }
        }

        public void SetGradationOverlayColor(int index, RGBAColor color)
        {
            if (_target.GetGradationOverlayColor(index) != color)
            {
                _commandFactory.Modify(_target, delegate ()
                {
                    _target.SetGradationOverlayColor(index, color);
                });
            }
        }

        public void SetGradationOverlayControlPoint(int index, float value)
        {
            if (_target.GetGradationOverlayControlPoint(index) != value)
            {
                _commandFactory.Modify(_target, delegate ()
                {
                    _target.SetGradationOverlayControlPoint(index, value);
                });
            }
        }

        public float GradationOverlayAngle
        {
            set
            {
                if (_target.GradationOverlayAngle != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.GradationOverlayAngle = value;
                    });
                }
            }
        }

        #endregion

        #region ドロップシャドウ(外側)

        public bool IsOuterShadowEnabled
        {
            set
            {
                if (_target.IsOuterShadowEnabled != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.IsOuterShadowEnabled = value;
                    });
                }
            }
        }

        public ProceduralShapeEffectBlendMode OuterShadowBlendMode
        {
            set
            {
                if (_target.OuterShadowBlendMode != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.OuterShadowBlendMode = value;
                    });
                }
            }
        }

        public RGBAColor OuterShadowColor
        {
            set
            {
                if (_target.OuterShadowColor != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.OuterShadowColor = value;
                    });
                }
            }
        }

        public float OuterShadowAngle
        {
            set
            {
                if (_target.OuterShadowAngle != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.OuterShadowAngle = value;
                    });
                }
            }
        }

        public float OuterShadowDistance
        {
            set
            {
                if (_target.OuterShadowDistance != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.OuterShadowDistance = value;
                    });
                }
            }
        }

        public float OuterShadowSize
        {
            set
            {
                if (_target.OuterShadowSize != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.OuterShadowSize = value;
                    });
                }
            }
        }

        public ProceduralShapeShadowType OuterShadowType
        {
            set
            {
                if (_target.OuterShadowType != value)
                {
                    _commandFactory.Modify(_target, delegate ()
                    {
                        _target.OuterShadowType = value;
                    });
                }
            }
        }

        #endregion
    }
}
