﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------
using System;
using System.Collections;
using System.Collections.Generic;
using System.Drawing;
using System.Diagnostics;
using System.Text.RegularExpressions;

namespace LECore.Manipulator
{
    using LECore.Structures;
    using LECore.Structures.Core;
    using LECore.Structures.Core.Command;

    using BackGroundCommandFactory = Structures.Core.Command.MementoCommandFactory<Structures.BackGround>;

    /// <summary>
    ///
    /// </summary>
    public class BackGroundManipulator : BaseManipulator
    {
        BackGround _targetBackGround;
        BackGroundCommandFactory _commandFactory;

        public BackGround BackGround { get { return _targetBackGround; } }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public BackGroundManipulator()
        {
            _commandFactory = new BackGroundCommandFactory
                ( delegate( Structures.BackGround mementoSrc )
                        {
                            return new Structures.Core.Command.BackGroundMement( mementoSrc );
                        });
        }

        /// <summary>
        /// コンストラクタ
        /// </summary>
        public BackGroundManipulator( ISubScene subScene)
        {
            _commandFactory = new BackGroundCommandFactory
                ( delegate( Structures.BackGround mementoSrc )
                        {
                            return new Structures.Core.Command.BackGroundMement( mementoSrc );
                        },
                  subScene);
        }

        /// <summary>
        /// 操作対象を関連付けます
        /// </summary>
        /// <param name="target"></param>
        public void BindTarget(BackGround targetBackGround)
        {
            Debug.Assert( targetBackGround != null );
            _targetBackGround = targetBackGround;
        }

        /// <summary>
        ///
        /// </summary>
        public Color BackGroundColor
        {
            set
            {
                if( _targetBackGround.BackGroundColor != value )
                {
                    _commandFactory.Modify( _targetBackGround, delegate()
                    {
                        _targetBackGround.BackGroundColor = value;
                    } );
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public Color GridColor
        {
            set
            {
                if( _targetBackGround.GridColor != value )
                {
                    _commandFactory.Modify( _targetBackGround, delegate()
                    {
                        _targetBackGround.GridColor = value;
                    } );
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public bool GridVisible
        {
            set
            {
                if( _targetBackGround.GridVisible != value )
                {
                    _commandFactory.Modify( _targetBackGround, delegate()
                    {
                        _targetBackGround.GridVisible = value;
                    } );
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public FVec2 ScreenSize
        {
            set
            {
                if( _targetBackGround.ScreenSize != value )
                {
                    _commandFactory.Modify( _targetBackGround, delegate()
                    {
                        _targetBackGround.ScreenSize = value;
                    } );
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public float GridSize
        {
            set
            {
                if( _targetBackGround.GridSize != value )
                {
                    _commandFactory.Modify( _targetBackGround, delegate()
                    {
                        _targetBackGround.GridSize = value;
                    } );
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public uint GridDivisionNum
        {
            set
            {
                if( _targetBackGround.GridDivisionNum != value )
                {
                    _commandFactory.Modify( _targetBackGround, delegate()
                    {
                        _targetBackGround.GridDivisionNum = value;
                    } );
                }
            }
        }

        /// <summary>
        ///
        /// </summary>
        public ITextureImage BackgroundImage
        {
            set
            {
                if( _targetBackGround.BackgroundImage != value )
                {
                    _commandFactory.Modify( _targetBackGround, delegate()
                    {
                        _targetBackGround.BackgroundImage = value;
                    } );
                }
            }
        }
    }
}
