﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#define NW4R_FROM_TOOL
#include <windows.h>

#include "nw4r/misc.h"
#include "Font.h"
#include "Color.h"


namespace NW4R
{
namespace Font
{
namespace UnManaged
{

void TextureObject::Set(
    u32         name,
    const void* pImage,
    TexFmt      format,
    u16         width,
    u16         height,
    u8          sheetNum,
    bool		blackWhiteInterpolationEnabled
    )
{
    m_Name          = name;

    m_pImage        = pImage;

    m_Format        = static_cast<u8>(format);
    m_Size.width    = width;
    m_Size.height   = height;

    m_SheetNum = sheetNum;
    m_ColorBlackWhiteInterpolationEnabled = blackWhiteInterpolationEnabled;
}

void TextureObject::SetTextureSettings(const TextureObject* pSrc)
{
    // 同一の画像をテクスチャとして使っているはず。
    NW4R_ASSERT(this->m_pImage == pSrc->m_pImage);
    NW4R_ASSERT(this->m_SheetNum == pSrc->m_SheetNum);

    this->m_Name = pSrc->m_Name;
}

/* ------------------------------------------------------------------------
        文字ストリーム
   ------------------------------------------------------------------------ */

/*---------------------------------------------------------------------------*
  Name:         Font::InitReaderFunc( FontEncoding )

  Description:  このフォントが生成するCharStrmReaderが対応する
                エンコーディング方式を決定します。

  Arguments:    encoding:   生成するCharStrmReaderが対応するエンコーディング

  Returns:      なし。
 *---------------------------------------------------------------------------*/
void
Font::InitReaderFunc( FontEncoding encoding )
{
    NW4R_POINTER_ASSERT( this );

    switch( encoding )
    {
    case FONT_ENCODING_UTF8:    mReaderFunc = &CharStrmReader::ReadNextCharUTF8;    break;
    case FONT_ENCODING_UTF16:   mReaderFunc = &CharStrmReader::ReadNextCharUTF16;   break;
    case FONT_ENCODING_SJIS:    mReaderFunc = &CharStrmReader::ReadNextCharSJIS;    break;
    case FONT_ENCODING_CP1252:  /* デフォルトと同じ / breakしない */
    default:
        mReaderFunc = &CharStrmReader::ReadNextCharCP1252;
        break;
    }
}






} /* UnManaged */
} /* namespace ut */
} /* namespace nw4r */
