﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_MATH_CONSTANT_H_
#define NW4R_MATH_CONSTANT_H_

#include <cfloat>
#include "nw4r/math/config.h"

namespace nw4r { namespace math {


const f32 F_E       = 2.718281828459045f;   // ネピア数 (自然対数の底) e
const f32 F_LOG2E   = 1.442695040888963f;   // log2(e)
const f32 F_LOG10E  = 0.434294481903251f;   // log10(e)
const f32 F_LN2     = 0.693147180559945f;   // ln(2)
const f32 F_LN10    = 2.302585092994045f;   // ln(10)
const f32 F_PI      = 3.141592653589793f;   // π
const f32 F_SQRTPI  = 1.772453850905516f;   // sqrt(π)
const f32 F_SQRT2   = 1.414213562373095f;   // sqrt(2)
const f32 F_SQRT3   = 1.732050807568877f;   // sqrt(3)

const f32 F_INVLN2  = 1.442695040888963f;   // 1/ln2


const f32 F_MAX     = FLT_MAX;              // 最大の正の数 = 3.40282346638529 * 10^38
const f32 F_MIN     = FLT_MIN;              // 最小の正の数 = 1.17549435082229 * 10^-38

#if _MSL_FLOAT_HEX

const f32 F_NAN     =  -(0.0f/0.0f);        // 非数
const f32 F_INF     =  0x1.000000P128F;     // ∞
const f32 F_NINF    = -0x1.000000P128F;     // -∞
const f32 F_ULP     =  0x1.000000P-23F;     // 1.0f + x != 1.0f を満たす最小の正の値
                                            // = 0.00000011920928955078125
#else   //  _MSL_FLOAT_HEX

namespace detail
{
    const u32 I_NAN     = 0x7FFFFFFF;   // sign=+ exp=max frac=max
    const u32 I_INF     = 0x7F800000;   // sign=+ exp=max frac=0
    const u32 I_NINF    = 0xFF800000;   // sign=- exp=max frac=0
    const u32 I_ULP     = 0x34000000;   // sign=+ exp=-23 frac=0
}
const f32 F_NAN     = *reinterpret_cast<const f32*>(&detail::I_NAN);    // 非数
const f32 F_INF     = *reinterpret_cast<const f32*>(&detail::I_INF);    // ∞
const f32 F_NINF    = *reinterpret_cast<const f32*>(&detail::I_NINF);   // -∞
const f32 F_ULP     = *reinterpret_cast<const f32*>(&detail::I_ULP);    // 1.0f + x != 1.0f を満たす最小の正の値

#endif  // _MSL_FLOAT_HEX


}}  // nw4r::math

/* NW4R_MATH_CONSTANT_H_ */
#endif
