﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_MATH_CONFIG_H_
#define NW4R_MATH_CONFIG_H_

#include <dolphin/types.h>
#include <dolphin/mtx.h>

#ifdef WIN32
  // DolphinSDKのMTXライブラリをPCでビルドしたものを利用している
  #define NW4R_MATH_GENERIC
#endif

#ifdef GEKKO
  #define NW4R_MATH_BROADWAY
//  #include <dolphin.h>
  #include <nw4r/misc.h>
#endif

#if !defined(NW4R_MATH_GENERIC)
  #if !defined(NW4R_MATH_BROADWAY)
  #define NW4R_MATH_GENERIC
  #endif
#elif defined(NW4R_MATH_BROADWAY)
  #undef NW4R_MATH_BROADWAY
#endif

#if defined(NW4R_MATH_BROADWAY)
  #define NW4R_MATH_REPORT OSReport
  #define NW4R_MATH_WARNING NW4R_WARNING
#else
  #include <cstdio>
  #define NW4R_MATH_REPORT std::printf

  // VC7では__VA_ARGS__が使えないのでパラメータ付きのワーニングは使わないように
  #define NW4R_MATH_WARNING(exp, msg) (void) ( (exp) || ( std::printf(msg), 0 ) )
#endif

#define NW4R_MATH_INLINE inline



/* NW4R_MATH_CONFIG_H_ */
#endif
