﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW_CONFIG_COMPILER_MSVC_H_
#define NW_CONFIG_COMPILER_MSVC_H_

#if !defined(__midl) && (defined(_X86_) || defined(_M_IX86)) && _MSC_VER >= 1300
#define NW_COMPILER_WITH_W64
#endif

#define NW_NO_THROW     throw()
#define NW_NO_INLINE(function)    __declspec(noinline) function

#define NW_FILE_NAME __FUNCTION__
#define NW_LINE_NUMBER __LINE__
#define NW_ALIGN(n)   __declspec(align(n))

#define NW_DEPRECATED_FUNCTION_MSG(MFunc, msg) __declspec(deprecated(msg)) MFunc
#define NW_CHECKED_ARRAY_ITERATOR(MIte, MNum) stdext::make_checked_array_iterator(MIte, MNum)
#define NW_CHAR_TRAITS_COPY(MType, MDest, MDestSize, MFrom, MCount) std::char_traits<MType>::_Copy_s(MDest, MDestSize, MFrom, MCount)

#include <limits.h>
#include <float.h>

typedef __int8              s8;
typedef __int16             s16;
typedef __int32             s32;
typedef __int64             s64;
typedef unsigned __int8     u8;
typedef unsigned __int16    u16;
typedef unsigned __int32    u32;
typedef unsigned __int64    u64;
typedef float               f32;
typedef double              f64;

#if ! defined(_SPTR_DEFINED)
#define _SPTR_DEFINED
typedef s32                 sptr;
#endif

#if ! defined(_UPTR_DEFINED)
#define _UPTR_DEFINED
typedef u32                 uptr;
#endif

#if ! defined(_UINT_DEFINED)
#define _UINT_DEFINED
typedef unsigned int        uint;
#endif

#if ! defined(_CHAR8_DEFINED)
#define _CHAR8_DEFINED
typedef char                char8;
#endif

#if ! defined(_CHAR16_DEFINED)
#define _CHAR16_DEFINED
typedef wchar_t             char16;
#endif

#if ! defined(_CHAR32_DEFINED)
#define _CHAR32_DEFINED
typedef u32                 char32;
#endif

#if ! defined(_BIT8_DEFINED)
#define _BIT8_DEFINED
typedef u8                  bit8;
#endif

#if ! defined(_BIT16_DEFINED)
#define _BIT16_DEFINED
typedef u16                 bit16;
#endif

#if ! defined(_BIT32_DEFINED)
#define _BIT32_DEFINED
typedef u32                 bit32;
#endif

#if ! defined(_BIT64_DEFINED)
#define _BIT64_DEFINED
typedef u64                 bit64;
#endif


namespace nw {

//! @details :private
inline int
isfinite(float f)
{
    return _finite( f );
}

//! @details :private
inline int
isnan(float f)
{
    return _isnan( f );
}

}   // namespace nw

void* operator new( size_t size, void* ptr );
void* operator new[]( size_t size, void* ptr );
void  operator delete( void* memory, void* ptr );
void  operator delete[]( void* memory, void* ptr );

/* NW_CONFIG_COMPILER_MSVC_H_ */
#endif
