﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_UT_UNCOMPRESSHUFFMAN_H_
#define NW4R_UT_UNCOMPRESSHUFFMAN_H_

//#include <dolphin.h>
#include <dolphin/types.h>


//----------------------------------------------------------------
// 圧縮データヘッダー
//

typedef struct
{
    u8* destp;        // 4B
    s32 destCount;    // 4B
    u8* treep;        // 4B
    u32 srcTmp;       // 4B
    u32 destTmp;      // 4B
    s16 treeSize;     // 2B
    u8  srcTmpCnt;    // 1B
    u8  destTmpCnt;   // 1B
    u8  bitSize;      // 1B
    u8  headerSize;
    u8  _padding2[2]; // 3B
    u8  tree[0x200];  // 512B
                   // 計 540B
} CXUncompContextHuffman;


void CXUncompressHuffman(const void* srcp, void* dstp);
void CXInitUncompContextHuffman( CXUncompContextHuffman *context, void* dest );
s32  CXReadUncompHuffman( CXUncompContextHuffman *context, const void* data, u32 len );

inline u32
CXGetUncompressedSize(const void *srcp)
{
    const u8* p = reinterpret_cast<const u8*>(srcp);

    return static_cast<u32>( (*(p + 3) << 16)
                           | (*(p + 2) <<  8)
                           | (*(p + 1) <<  0) );
}

#endif // NW4R_UT_UNCOMPRESSHUFFMAN_H_
