﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_UT_RECT_H_
#define NW4R_UT_RECT_H_

#include <dolphin/types.h>
#include <nw4r/math/arithmetic.h>


namespace NW4R
{
namespace Font
{
namespace UnManaged
{



struct Rect
{
public:
    /* ------------------------------------------------------------------------
            変数
       ------------------------------------------------------------------------ */
    float left;
    float top;
    float right;
    float bottom;


    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- コンストラクタ/デストラクタ
            Rect()
    : left(0),
      top(0),
      right(0),
      bottom(0)
    {
    }

            Rect(float l, float t, float r, float b)
    : left(l),
      top(t),
      right(r),
      bottom(b)
    {
    }

            ~Rect()
    {
    }

    float   GetWidth() const
    {
        return right - left;
    }

    float   GetHeight() const
    {
        return bottom - top;
    }

    void    SetWidth(float width)
    {
        right = left + width;
    }

    void    SetHeight(float height)
    {
        bottom = top + height;
    }

    void    MoveTo(float x, float y)
    {
        right  = x + GetWidth();
        left   = x;
        bottom = y + GetHeight();
        top    = y;
    }

    void    Move(f32 dx, f32 dy)
    {
        left    += dx;
        right   += dx;
        top     += dy;
        bottom  += dy;
    }

    void    Normalize()
    {
        const f32 l = left;
        const f32 t = top;
        const f32 r = right;
        const f32 b = bottom;

        left    = nw4r::math::FSelect(r - l, l, r);
        right   = nw4r::math::FSelect(r - l, r, l);
        top     = nw4r::math::FSelect(b - t, t, b);
        bottom  = nw4r::math::FSelect(b - t, b, t);
    }
};



} /* UnManaged */
} /* namespace ut */
} /* namespace nw4r */

#endif //  NW4R_UT_RECT_H_
