﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#ifndef NW4R_UT_CHARSTRMREADER_H_
#define NW4R_UT_CHARSTRMREADER_H_

#include <dolphin/types.h>
#include "nw4r/misc.h"


namespace NW4R
{
namespace Font
{
namespace UnManaged
{

class CharStrmReader
{
    friend class Font;

public:
    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- コピーコンストラクタ/デストラクタ
                            CharStrmReader(const CharStrmReader& rhs)
    : mCharStrm(rhs.mCharStrm),
      mReadFunc(rhs.mReadFunc)
    {
    }

                            ~CharStrmReader()
    {
    }

    //---- ストリーム設定/取得/進行
    void                    Set(const char* stream)
    {
        NW4R_POINTER_ASSERT( this );
        NW4R_POINTER_ASSERT( stream );
        mCharStrm = stream;
    }

    void                    Set(const wchar_t* stream)
    {
        NW4R_POINTER_ASSERT( this );
        NW4R_ALIGN2_ASSERT( stream );
        NW4R_POINTER_ASSERT( stream );
        mCharStrm = stream;
    }

    const void*             GetCurrentPos() const
    {
        NW4R_POINTER_ASSERT( this );
        return mCharStrm;
    }

    u16                     Next()
    {
        NW4R_POINTER_ASSERT( this );
        return (this->*mReadFunc)();
    }

    CharStrmReader& operator=( const CharStrmReader& other)
    {
        this->mCharStrm = other.mCharStrm;
    }

private:
    /* ------------------------------------------------------------------------
            型
       ------------------------------------------------------------------------ */
    typedef u16 (CharStrmReader::*ReadNextCharFunc)();


    /* ------------------------------------------------------------------------
            変数
       ------------------------------------------------------------------------ */
    const void*             mCharStrm;      // ストリーム現在位置へのポインタ
    const ReadNextCharFunc  mReadFunc;      // ストリーム解釈関数へのポインタ


    /* ------------------------------------------------------------------------
            関数
       ------------------------------------------------------------------------ */
    //---- コンストラクタ
    explicit                CharStrmReader(ReadNextCharFunc func)
    : mCharStrm(NULL),
      mReadFunc(func)
    {
    }

    //---- ストリーム操作
    template <typename CharType>
    CharType                GetChar(int offset=0) const
    {
        const CharType* charStrm = reinterpret_cast<const CharType*>(mCharStrm);
        return *(charStrm + offset);
    }

    template <typename CharType>
    void                    StepStrm(int step=1)
    {
        const CharType*& charStrm = reinterpret_cast<const CharType*&>(mCharStrm);
        charStrm += step;
    }

    //---- ReadNextCharFunc
    u16 ReadNextCharUTF8();
    u16 ReadNextCharUTF16();
    u16 ReadNextCharCP1252();
    u16 ReadNextCharSJIS();
};



} /* UnManaged */
} /* namespace ut */
} /* namespace nw4r */

#endif //  NW4R_UT_COLOR_H_
