﻿// KerningReader.h

#pragma once

using namespace System;

#include <nn/fontll/fontll_ScalableFontEngine.h>

namespace NW4F
{
namespace FontConverter
{

//=============================================================================
// フォントからカーニングを抜き出すクラスです。
public ref class KerningReader
{
public:
    int InitializeFontEngine(System::IntPtr pHeap, uint32_t heapSize)
    {
        m_pFontEngine = new nn::fontll::ScalableFontEngine();

        return m_pFontEngine->Initialize(pHeap.ToPointer(), heapSize);
    }

    int LoadFont(System::IntPtr pNameBuffer, System::IntPtr pRawFile, uint32_t index, uint32_t nameBufferLen)
    {
        return m_pFontEngine->LoadFont(reinterpret_cast<char*>(pNameBuffer.ToPointer()), pRawFile.ToPointer(), index, nameBufferLen);
    }

    int SetFont(System::IntPtr pName)
    {
        return m_pFontEngine->SetFont(reinterpret_cast<char*>(pName.ToPointer()));
    }

    int SetScale(int32_t s00, int32_t s01, int32_t s10, int32_t s11)
    {
        return m_pFontEngine->SetScale(s00, s01, s10, s11);
    }

    int GetKerning(int32_t% dx, int32_t% dy, uint32_t id1, uint32_t id2)
    {
        int32_t dx2;
        int32_t dy2;
        int result = m_pFontEngine->GetKerning(&dx2, &dy2, id1, id2);
        dx = dx2;
        dy = dy2;
        return result;
    }

    int FinalizeFontEngine()
    {
        int result = m_pFontEngine->Finalize();
        delete m_pFontEngine;
        return result;
    }

private:
    nn::fontll::ScalableFontEngine* m_pFontEngine;
};

}   // namespace LayoutBinaryConverter
}   // namespace NW4F
