﻿using NintendoWare.Font;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace FontConverterNW4FProxy
{
    class NW4FOptions
    {
        // NW4F の FontConverterConsole の Programs.cs からほぼコピペ
        private const string OptionHelp = "h";
        private const string OptionConvertCtr2ToCafe = "ctr2cafe";
        private const string OptionSkipValidation = "skipvalidation";
        private const string OptionUseDtd = "usedtd";
        private const string OptionInput = "i";
        private const string OptionFilter = "f";
        private const string OptionOutput = "o";
        private const string OptionInputAnti = "ia";
        private const string OptionInputUseScfontKerning = "isck";
        private const string OptionInputFormat = "ic";
        private const string OptionInputFile = "if";
        private const string OptionInputFile2 = "ig";
        private const string OptionInputSystemFont = "isysfont";
        private const string OptionInputName = "in";
        private const string OptionInputOrder = "io";
        private const string OptionInputAverageWidth = "isw";
        private const string OptionInputWeight = "iwg";
        private const string OptionInputSize = "is";
        private const string OptionInputWidthType = "it";
        private const string OptionInputWidth = "iw";
        private const string OptionOutputAlter = "oa";
        private const string OptionOutputBottom = "ob";
        private const string OptionOutputBackgroundColor = "ocb";
        private const string OptionOutputGridColor = "ocg";
        private const string OptionOutputMarginColor = "ocm";
        private const string OptionOutputWidthBarColor = "ocw";
        private const string OptionOutputNullBlockColor = "ocn";
        private const string OptionOutputEncoding = "oe";
        public const string OptionOutputFile = "of";
        private const string OptionOutputDrawGrid = "og";
        private const string OptionOutputKerning = "ok";
        private const string OptionOutputNoKerning = "onok";

        private const string OptionOutputHeight = "oh";
        private const string OptionOutputLinefeed = "oh";
        private const string OptionOutputFormat = "oi";
        private const string OptionOutputLeft = "ol";
        private const string OptionOutputMarginX = "om";
        private const string OptionOutputMarginY = "on";
        private const string OptionOutputOrder = "oo";
        private const string OptionOutputGroup = "op";
        private const string OptionOutputRight = "or";
        private const string OptionOutputSheetPixels = "os";
        private const string OptionOutputTop = "ot";
        private const string OptionOutputWidth = "ow";
        private const string OptionOutputSheetSize = "ox";

        private const string InputBmp = "bmp";
        private const string InputImage = "image";
        private const string InputFont = LibFormat.ExtensionFont;
        private const string InputWin = "win";
        private const string InputLC = "lc";
        private const string OutputBMP = "bmp";
        private const string OutputImage = "image";
        private const string OutputFont = LibFormat.ExtensionFont;
        private const string OutputOrder = "xlor";
        private const string OutputFormat = "format";

        private const int DefFontSize = -1;
        private const int DefFontWeight = 400;

        public static readonly CmdLine.OptionDef[] Options =
        {
            new CmdLine.OptionDef(OptionHelp,                     CmdLine.Option.None),
            new CmdLine.OptionDef(OptionConvertCtr2ToCafe,            CmdLine.Option.None),
            new CmdLine.OptionDef(OptionSkipValidation,            CmdLine.Option.None),
            new CmdLine.OptionDef(OptionUseDtd,                       CmdLine.Option.None),
            new CmdLine.OptionDef(OptionInput,                        CmdLine.Option.One),
            new CmdLine.OptionDef(OptionFilter,                       CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutput,                       CmdLine.Option.One),
            new CmdLine.OptionDef(OptionInputFile,                   CmdLine.Option.One),
            new CmdLine.OptionDef(OptionInputSystemFont,              CmdLine.Option.One),
            new CmdLine.OptionDef(OptionInputOrder,              CmdLine.Option.One),
            new CmdLine.OptionDef(OptionInputFormat,             CmdLine.Option.One/*, CheckOptionInputFormatWarning_*/),
            new CmdLine.OptionDef(OptionInputName,                   CmdLine.Option.One),
            new CmdLine.OptionDef(OptionInputSize,                   CmdLine.Option.One),
            new CmdLine.OptionDef(OptionInputAverageWidth,           CmdLine.Option.One),
            new CmdLine.OptionDef(OptionInputWidthType,          CmdLine.Option.LTOne),
            new CmdLine.OptionDef(OptionInputWidth,              CmdLine.Option.One),
            new CmdLine.OptionDef(OptionInputAnti,               CmdLine.Option.None),
            new CmdLine.OptionDef(OptionInputUseScfontKerning,   CmdLine.Option.None),
            new CmdLine.OptionDef(OptionOutputFile,              CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputOrder,             CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputDrawGrid,          CmdLine.Option.None),
            new CmdLine.OptionDef(OptionOutputKerning,           CmdLine.Option.None),
            new CmdLine.OptionDef(OptionOutputNoKerning,           CmdLine.Option.None),
            new CmdLine.OptionDef(OptionOutputAlter,             CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputLinefeed,          CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputTop,                   CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputBottom,                CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputLeft,              CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputRight,             CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputWidth,             CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputEncoding,          CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputHeight,                CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputMarginX,          CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputMarginY,          CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputFormat,                CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputGroup,               CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputSheetSize,           CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputSheetPixels,         CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputBackgroundColor,    CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputGridColor,          CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputMarginColor,        CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputWidthBarColor,      CmdLine.Option.One),
            new CmdLine.OptionDef(OptionOutputNullBlockColor,     CmdLine.Option.One),
        };

    }
}
