﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font.Runtime
{
    using System;
    using System.Diagnostics.CodeAnalysis;
    using System.Runtime.InteropServices;

    public partial class RtConsts
    {
        /// <summary>
        /// バージョンを作成します。
        /// バージョンがメジャーとマイナーで表現されるバージョンです。
        /// </summary>
        /// <param name="major"></param>
        /// <param name="minor"></param>
        /// <returns></returns>
        public static ushort MakeVersion(byte major, byte minor)
        {
            return (ushort)(
                ((ushort)major << 8) | ((ushort)minor << 0)
            );
        }

        /// <summary>
        /// バージョンを作成します。
        /// バージョンがメジャー/マイナー/マイクロ/バグフィックスで表現されるバージョンです。
        /// </summary>
        /// <param name="major"></param>
        /// <param name="minor"></param>
        /// <param name="micro"></param>
        /// <param name="special"></param>
        /// <returns></returns>
        public static uint MakeVersion(byte major, byte minor, byte micro, byte binaryBugFix)
        {
            return (uint)(
                ((uint)major << 24) | ((uint)minor << 16)
                | ((uint)micro << 8) | (uint)binaryBugFix);
        }
    }

    /// <summary>
    /// NintendoWare 標準バイナリファイルヘッダです。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    [SuppressMessage("Microsoft.StyleCop.CSharp.MaintainabilityRules", "SA1401:FieldsMustBePrivate", Justification = "Binay Image")]
    public class BinaryFileHeader
    {
        public static readonly int Length = Marshal.SizeOf(typeof(BinaryFileHeader));

        /// <summary>
        /// ファイルシグネチャです。
        /// </summary>
        public Signature32 Signature;

        /// <summary>
        /// バイトオーダーマークです。
        /// </summary>
        public ushort ByteOrder;

        /// <summary>
        /// このヘッダサイズのサイズです。
        /// </summary>
        public ushort HeaderSize;

        /// <summary>
        /// ファイルバージョンです。
        /// </summary>
        public uint Version;

        /// <summary>
        /// ファイルサイズです。
        /// </summary>
        public uint FileSize;

        /// <summary>
        /// ブロック数です。
        /// </summary>
        public ushort DataBlocks;

        /// <summary>
        /// 予約領域です。
        /// </summary>
        private ushort reserved;
    }

    /// <summary>
    /// NintendoWare 標準バイナリブロックヘッダです。
    /// </summary>
    [StructLayout(LayoutKind.Sequential)]
    [SuppressMessage("Microsoft.StyleCop.CSharp.MaintainabilityRules", "SA1401:FieldsMustBePrivate", Justification = "Binay Image")]
    public class BinaryBlockHeader
    {
        public static readonly int Length = Marshal.SizeOf(typeof(BinaryBlockHeader));

        /// <summary>
        /// ブロック種別名
        /// </summary>
        public Signature32 Kind;

        /// <summary>
        /// ブロック全体のサイズです。
        /// </summary>
        public uint Size;
    }
}
