﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Diagnostics;

    public interface IProgressControl
    {
        bool IsCanceled();

        void SetStatusString(string msgId);

        void ResetProgressBarPos();

        void SetProgressBarMax(int max);

        void StepProgressBar(int step);
    }

    public class ProgressControl
    {
        private static ProgressControl staticThis;
        private static TraceSource traceSource;
        private IProgressControl instance;

        /// <summary>
        /// スタティックコンストラクタです。
        /// </summary>
        static ProgressControl()
        {
            traceSource = new TraceSource("FontConverterTrace", SourceLevels.All);
            traceSource.Listeners.Remove("Default");
        }

        private ProgressControl(IProgressControl ctrl)
        {
            this.instance = ctrl;
        }

        public static void SetInstance(IProgressControl ctrl)
        {
            staticThis = new ProgressControl(ctrl);
        }

        public static ProgressControl GetInstance()
        {
            Debug.Assert(staticThis != null);
            return staticThis;
        }

        public static void AddListener(TraceListener listener)
        {
            traceSource.Listeners.Add(listener);
        }

        public static void RemoveListener(TraceListener listener)
        {
            traceSource.Listeners.Remove(listener);
        }

        public static void Error(string message)
        {
            traceSource.TraceEvent(TraceEventType.Error, 0, message);
        }

        public static void Error(string format, params object[] arg)
        {
            traceSource.TraceEvent(TraceEventType.Error, 0, format, arg);
        }

        public static void Warning(string message)
        {
            traceSource.TraceEvent(TraceEventType.Warning, 0, message);
        }

        public static void Warning(string format, params object[] arg)
        {
            traceSource.TraceEvent(TraceEventType.Warning, 0, format, arg);
        }

        public bool IsCanceled()
        {
            return this.instance.IsCanceled();
        }

        public void SetStatusString(string msgId)
        {
            this.instance.SetStatusString(msgId);
        }

        public void ResetProgressBarPos()
        {
            this.instance.ResetProgressBarPos();
        }

        public void SetProgressBarMax(int max)
        {
            this.instance.SetProgressBarMax(max);
        }

        public void StepProgressBar(int step)
        {
            this.instance.StepProgressBar(step);
        }

        public void StepProgressBar()
        {
            this.StepProgressBar(1);
        }
    }
}
