﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System.Diagnostics;

    public class Rpt
    {
        [Conditional("DEBUG")]
        public static void _RPT0(string format)
        {
            Debug.Write(format);
        }

        [Conditional("DEBUG")]
        public static void _RPT1(string format, object arg1)
        {
            Debug.Write(string.Format(format, arg1));
        }

        [Conditional("DEBUG")]
        public static void _RPT2(string format, object arg1, object arg2)
        {
            Debug.Write(string.Format(format, arg1, arg2));
        }

        [Conditional("DEBUG")]
        public static void _RPT3(string format, object arg1, object arg2, object arg3)
        {
            Debug.Write(string.Format(format, arg1, arg2, arg3));
        }

        [Conditional("DEBUG")]
        public static void _RPT4(string format, object arg1, object arg2, object arg3, object arg4)
        {
            Debug.Write(string.Format(format, arg1, arg2, arg3, arg4));
        }

        public static void InitForConsole()
        {
            // 既定のリスナを削除
            Debug.Listeners.Remove("Default");

            // 標準エラーに出力するリスナを追加する。
            Debug.Listeners.Add(new ConsoleTraceListener(true));
        }
    }
}
