﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    /// <summary>
    /// FontEncoding用のViewModelです。
    /// </summary>
    public class CharEncodingViewModel
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="name">表示文字列です。</param>
        /// <param name="encoding">FontEncodingの値です。</param>
        public CharEncodingViewModel(string name, CharEncoding encoding)
        {
            this.Name = name;
            this.Encoding = encoding;
        }

        /// <summary>
        /// 表示文字列を取得します。
        /// </summary>
        public string Name { get; private set; }

        /// <summary>
        /// CharEncodingの値を取得します。
        /// </summary>
        public CharEncoding Encoding { get; private set; }
    }
}
