﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Collections.Generic;
    using System.ComponentModel;
    using System.Windows;

    /// <summary>
    /// NnsXmlFileListクラスの非同期読み込み用プロキシクラスです。
    /// </summary>
    public class OrderFileListProxy
    {
        private List<NnsFileInfo> list;

        /// <summary>
        /// 読み込みが完了したときに発生します。
        /// </summary>
        public event EventHandler Loaded;

        /// <summary>
        /// 読み込みが完了したかどうかを判定する値を取得します。
        /// </summary>
        public bool IsLoaded { get; private set; }

        /// <summary>
        /// 順序ファイルが置かれているディレクトリを取得します。
        /// </summary>
        public string OrderFilesDir { get; private set; }

        /// <summary>
        /// 順序ファイルリストを取得します。
        /// </summary>
        public List<NnsFileInfo> OrderFiles
        {
            get
            {
                if (!this.IsLoaded)
                {
                    if (null == this.list)
                    {
                        var backgroundWorker = new BackgroundWorker();
                        backgroundWorker.DoWork += this.CollectFile;
                        backgroundWorker.RunWorkerAsync();
                        backgroundWorker.RunWorkerCompleted += (sender, e) => this.FileCollected((NnsXmlFileList)e.Result);

                        this.list = new List<NnsFileInfo>
                        {
                            new NnsFileInfo()
                            {
                                Title = Strings.IDS_NOW_READING,
                                FileName = null
                            },
                        };
                    }
                }

                return this.list;
            }
        }

        private void CollectFile(object sender, DoWorkEventArgs e)
        {
            var orderFiles = new NnsXmlFileList("xlor", ".xlor");
            orderFiles.CollectFiles();
            e.Result = orderFiles;
        }

        private void FileCollected(NnsXmlFileList orderFiles)
        {
            if (orderFiles.GetNum() == 0)
            {
                MessageBox.Show(
                    Strings.IDS_WARN_NO_GLYPH_ORDER,
                    Strings.IDS_ERROR,
                    MessageBoxButton.OK,
                    MessageBoxImage.Error);
            }

#if ORIGINAL_TOOLTIP_CODE
        UINT maxLen = 0;
#endif
            this.OrderFilesDir = orderFiles.GetFileDir();

            var list = new List<NnsFileInfo>(orderFiles.GetNum());

            for (int i = 0; i < orderFiles.GetNum(); i++)
            {
                var info = orderFiles[i];

#if ORIGINAL_TOOLTIP_CODE
                    var title = info.Title;
                    maxLen = max(maxLen, title.length());
#endif

                list.Add(info);
            }

#if ORIGINAL_TOOLTIP_CODE
                m_pOrderCombo->Init(m_pTip, maxLen);
#endif

            this.list = list;
            this.IsLoaded = true;

            var handler = this.Loaded;
            if (handler != null)
            {
                var e = new EventArgs();
                handler(this, e);
            }
        }
    }
}
