﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.Collections.Generic;
    using System.IO;
    using System.Reflection;

    public class NnsXmlFileList
    {
        private readonly NnsFileList files = new NnsFileList();
        private string findDir;
        private string findExt;

        public NnsXmlFileList(string findDir, string findExt)
        {
            this.findDir = findDir;
            this.findExt = findExt;
        }

        public NnsFileInfo this[int no]
        {
            get { return this.files[no]; }
        }

        public static string GetExeFileDir()
        {
            return Path.GetDirectoryName(Assembly.GetEntryAssembly().Location);
        }

        public int GetNum()
        {
            return this.files.Count;
        }

        public string GetFileDir()
        {
            var execDir = GetExeFileDir();
            return Path.Combine(execDir, this.findDir);
        }

        public void CollectFiles()
        {
            string[] files = null;
            var findDir = this.findDir;
            var findExt = this.findExt;

            // exe相対
            {
                var exed = GetExeFileDir();
                var patDir = Path.Combine(exed, findDir);

                if (Directory.Exists(patDir))
                {
                    var pattern = "*" + findExt;
                    try
                    {
                        files = Directory.GetFiles(patDir, pattern);
                    }
                    catch (IOException)
                    {
                    }
                    catch (UnauthorizedAccessException)
                    {
                    }
                }
            }

            if (files != null)
            {
                NnsXmlFile xml = new NnsXmlFile();

                foreach (var filePath in files)
                {
                    string fname;
                    string ext;

                    fname = Path.GetFileNameWithoutExtension(filePath);
                    ext = Path.GetExtension(filePath);

                    if (string.Equals(ext, findExt, StringComparison.InvariantCultureIgnoreCase))
                    {
                        string path;
                        NnsFileInfo nfi = new NnsFileInfo();

                        path = filePath;

                        try
                        {
                            xml.Load(nfi, path);
                        }
                        catch (GeneralException ge)
                        {
                            ProgressControl.Warning(ge.GetMsg());
                            Rpt._RPT1("Error: {0}\n", ge.GetMsg());
                        }

                        if (xml.IsSuccess())
                        {
                            this.files.Add(nfi);
                        }
                    }
                }
            }

            this.files.Sort();
        }

        private class NnsFileList : List<NnsFileInfo>
        {
        }
    }
}
