﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace NintendoWare.Font
{
    using System;
    using System.IO;
    using System.Windows;

    internal class FileOverwriteConfirmDialog
    {
        public static void Show(string file)
        {
            if (File.Exists(file))
            {
                var ret = MessageBox.Show(
                            string.Format(Strings.IDS_MSG_OVERWRITE_FILE, file),
                            Strings.IDS_MSG_OVERWRITE_FILE_TITLE,
                            MessageBoxButton.OKCancel/*|MB_DEFBUTTON2*/,
                            MessageBoxImage.Warning);

                if (ret != MessageBoxResult.OK)
                {
                    // cancel
                    throw new ConvertCancelException();
                }
            }
        }
    }

    internal class ConvertCancelException : Exception
    {
    }
}
