﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

using System;
using System.ComponentModel;

using SysDebug = System.Diagnostics.Debug;

namespace EffectMaker.UIControls.EffectBrowser.Utilities
{
    /// <summary>
    /// コントロールのDispose処理をフックします。
    /// </summary>
    public sealed class ControlDisposingHook : IComponent
    {
        /// <summary>
        /// 同期オブジェクト
        /// </summary>
        private object syncObj;

        /// <summary>
        /// Disposeのフック処理
        /// </summary>
        private Action onDisposing;

        /// <summary>
        /// コンストラクタです。
        /// </summary>
        /// <param name="components">デザイナで生成されたcomponentsオブジェクト</param>
        /// <param name="onDisposing">Disposeのフック処理</param>
        public ControlDisposingHook(IContainer components, Action onDisposing)
        {
            SysDebug.Assert(components != null, "components が null");
            SysDebug.Assert(onDisposing != null, "onDisposing が null");

            this.syncObj = new object();
            this.onDisposing = onDisposing;
            this.IsDisposed = false;

            components.Add(this);
        }

        /// <summary>
        /// Dispose処理を行うときに発生します。
        /// </summary>
        event EventHandler IComponent.Disposed
        {
            add { }
            remove { }
        }

        /// <summary>
        /// Disposeされたかどうか取得します。
        /// </summary>
        public bool IsDisposed { get; private set; }

        /// <summary>
        /// Siteを取得または設定します。
        /// </summary>
        ISite IComponent.Site { get; set; }

        /// <summary>
        /// Dispose処理を行います。
        /// </summary>
        public void Dispose()
        {
            lock (this.syncObj)
            {
                if (this.IsDisposed) return;

                this.onDisposing();

                this.IsDisposed = true;
            }
        }
    }
}
