﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.FileListView
{
    using EffectMaker.UIControls.EffectBrowser.Data;

    /// <summary>
    /// The search file info.
    /// </summary>
    public class SearchFileInfo
    {
        #region Enums

        /// <summary>
        /// The search mode kind.
        /// </summary>
        public enum SearchModeKind
        {
            /// <summary>
            /// The reference file.
            /// </summary>
            ReferenceFile = 0,

            /// <summary>
            /// The unused file.
            /// </summary>
            UnusedFile = 1,

            /// <summary>
            /// The emitter set used file.
            /// </summary>
            EmitterSetUsedFile = 2,

            /// <summary>
            /// The undefined.
            /// </summary>
            Undefined = -1
        }

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets or sets the file kind.
        /// </summary>
        public FileKindType FileKind { get; set; }

        /// <summary>
        /// Gets or sets the reference file path.
        /// </summary>
        public string ReferenceFilePath { get; set; }

        /// <summary>
        /// Gets or sets the search mode.
        /// </summary>
        public SearchModeKind SearchMode { get; set; }

        #endregion

        #region Public Methods and Operators

        /// <summary>
        /// The clone.
        /// </summary>
        /// <returns>
        /// The <see cref="SearchFileInfo"/>.
        /// </returns>
        public SearchFileInfo Clone()
        {
            return new SearchFileInfo
                       {
                           FileKind = this.FileKind,
                           SearchMode = this.SearchMode,
                           ReferenceFilePath = this.ReferenceFilePath,
                       };
        }

        #endregion
    }
}
