﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.FileListView.Base
{
    using System.Windows.Forms;

    /// <summary>
    /// The eb file list view column.
    /// </summary>
    public class EBFileListViewColumn
    {
        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="EBFileListViewColumn"/> class.
        /// </summary>
        public EBFileListViewColumn()
        {
            this.Visible = true;
            this.SortOrder = SortOrder.Ascending;
        }

        #endregion

        #region Public Properties

        /// <summary>
        /// Gets or sets the column header.
        /// </summary>
        public ColumnHeader ColumnHeader { get; set; }

        /// <summary>
        /// Gets the column kinds.
        /// </summary>
        public EBFileListView.ColumnKinds ColumnKinds
        {
            get
            {
                return (EBFileListView.ColumnKinds)this.ColumnHeader.Tag;
            }
        }

        /// <summary>
        /// Gets or sets the display index.
        /// </summary>
        public int DisplayIndex { get; set; }

        /// <summary>
        /// Gets or sets the index.
        /// </summary>
        public int Index { get; set; }

        /// <summary>
        /// Gets or sets the sort order.
        /// </summary>
        public SortOrder SortOrder { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether visible.
        /// </summary>
        public bool Visible { get; set; }

        #endregion

        #region Public Methods and Operators

        /// <summary>
        /// The copy.
        /// </summary>
        /// <param name="src">
        /// The src.
        /// </param>
        public void Copy(EBFileListViewColumn src)
        {
            this.Visible = src.Visible;
            this.Index = src.Index;
            this.DisplayIndex = src.DisplayIndex;
            this.ColumnHeader.Width = src.ColumnHeader.Width;
            this.SortOrder = src.SortOrder;
        }

        /// <summary>
        /// The toggle sort order.
        /// </summary>
        public void ToggleSortOrder()
        {
            this.SortOrder = (this.SortOrder == SortOrder.Ascending) ? SortOrder.Descending : SortOrder.Ascending;
        }

        #endregion
    }
}
