﻿// --------------------------------------------------------------------------------
// <copyright>
// Copyright (C)Nintendo. All rights reserved.
//
// These coded instructions, statements, and computer programs contain proprietary
// information of Nintendo and/or its licensed developers and are protected by
// national and international copyright laws. They may not be disclosed to third
// parties or copied or duplicated in any form, in whole or in part, without the
// prior written consent of Nintendo.
//
// The content herein is highly confidential and should be handled accordingly.
// </copyright>
// --------------------------------------------------------------------------------

namespace EffectMaker.UIControls.EffectBrowser.Controls.Basic
{
    using System.Windows.Forms;

    using EffectMaker.UIControls.EffectBrowser.Utilities;

    /// <summary>
    /// The eb tool tip.
    /// </summary>
    public class EBToolTip : ToolTip
    {
        #region Constructors and Destructors

        /// <summary>
        /// Initializes a new instance of the <see cref="EBToolTip"/> class.
        /// </summary>
        public EBToolTip()
        {
            this.AutomaticDelay = 100;

            // 勝手に消えないように長めに表示させる
            this.AutoPopDelay = 30000;

            // 親が非アクティブでも表示させる
            this.ShowAlways = true;
        }

        #endregion

        #region Properties

        /// <summary>
        /// オーバーライド。
        /// </summary>
        protected override bool CanRaiseEvents
        {
            get
            {
                return !ControlEventSuppressBlock.Enabled && base.CanRaiseEvents;
            }
        }

        #endregion
    }
}
