﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml;

namespace EffectMaker.UIDialogs.SearchDialog
{
    /// <summary>
    /// 検索を行うプラグインです。
    /// </summary>
    public abstract class SearchPlugin
    {
        /// <summary>
        /// コンストラクタです。
        /// </summary>
        public SearchPlugin()
        {
            this.InitializeBase();
        }

        /// <summary>
        /// 比較方法を取得または設定します。
        /// </summary>
        public int Operator { get; set; }

        /// <summary>
        /// 選択可能な比較方法を取得します。
        /// </summary>
        public Dictionary<string, int> Operators { get; protected set; }

        /// <summary>
        /// 選択可能な条件値を取得します。
        /// </summary>
        public Dictionary<string, string> ConditionValues { get; protected set; }

        /// <summary>
        /// 検索します。
        /// </summary>
        /// <param name="node">検索対象の XML 要素</param>
        /// <param name="logger">ロガー</param>
        /// <returns>見つかった場合は true、それ以外は false を返します。</returns>
        public abstract bool Search(XmlNode node, SearchLogger logger);

        /// <summary>
        /// 置換可能かを取得します。
        /// </summary>
        /// <returns>置換可能なら true を返します。</returns>
        public virtual bool CanReplace()
        {
            return false;
        }

        /// <summary>
        /// 置換します。
        /// </summary>
        /// <param name="value">置換する値</param>
        /// <param name="Node">検索対象の XML 要素</param>
        /// <param name="logger">ロガー</param>
        /// <returns>置換した場合は true を返します。</returns>
        public virtual bool Replace(object value, XmlNode Node, SearchLogger logger)
        {
            return false;
        }

        private void InitializeBase()
        {
            this.Operators = new Dictionary<string, int>
            {
                {"と等しい", 0},
                {"ではない", 1},
            };
            this.ConditionValues = new Dictionary<string, string>();
            this.Operator = 0;
        }
    }
}
